/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.scm.core;

import com.sourceclear.scm.core.TargetType;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class SCMTarget {
    public static final SCMTarget EMPTY = new Builder().build();
    private final String name;
    private final TargetType type;

    private SCMTarget(Builder builder) {
        this.name = builder.name;
        this.type = builder.type;
    }

    public String toString() {
        return String.format("SCMTarget [name=%s, type=%s]", new Object[]{this.name, this.type});
    }

    public String getName() {
        return this.name;
    }

    public TargetType getType() {
        return this.type;
    }

    public static class Builder {
        private String name;
        private TargetType type;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withType(TargetType type) {
            this.type = type;
            return this;
        }

        public SCMTarget build() {
            return new SCMTarget(this);
        }
    }
}

