/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.sgl;

import com.carrotsearch.hppc.ObjectIntHashMap;
import com.carrotsearch.hppc.ObjectIntMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class Tarjan {
    private final ObjectIntMap<Vertex> numbers = new ObjectIntHashMap();
    private final ObjectIntMap<Vertex> smallestReachable = new ObjectIntHashMap();
    private int i = 0;
    private final Stack<Vertex> stack = new Stack();
    private final Set<Vertex> onStack = new HashSet<Vertex>();
    private final Set<Set<Vertex>> result = new HashSet<Set<Vertex>>();
    private final Graph graph;

    private Tarjan(Graph graph) {
        this.graph = graph;
    }

    public static Set<Set<Vertex>> compute(Graph graph) {
        return new Tarjan(graph).compute();
    }

    public Set<Set<Vertex>> compute() {
        for (Vertex v : this.graph.traversal().V(new Object[0]).toStream()::iterator) {
            if (this.numbers.containsKey((Object)v)) continue;
            this.scc(v);
        }
        return this.result;
    }

    private void scc(Vertex v) {
        this.numbers.put((Object)v, this.i);
        this.smallestReachable.put((Object)v, this.i);
        ++this.i;
        this.stack.push(v);
        this.onStack.add(v);
        for (Vertex w : this.graph.traversal().V(new Object[]{v.id()}).out(new String[0]).toStream()::iterator) {
            boolean visited = this.numbers.containsKey((Object)w);
            if (!visited) {
                this.scc(w);
                this.smallestReachable.put((Object)v, Math.min(this.smallestReachable.get((Object)v), this.smallestReachable.get((Object)w)));
                continue;
            }
            if (!this.onStack.contains(w)) continue;
            this.smallestReachable.put((Object)v, Math.min(this.smallestReachable.get((Object)v), this.numbers.get((Object)w)));
        }
        if (this.numbers.get((Object)v) == this.smallestReachable.get((Object)v)) {
            Vertex w;
            HashSet<Vertex> scc = new HashSet<Vertex>();
            do {
                w = this.stack.pop();
                this.onStack.remove(w);
                scc.add(w);
            } while (w != v);
            this.result.add(scc);
        }
    }
}

