/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.sgl.lang;

import com.sourceclear.sgl.Schema;
import com.sourceclear.sgl.lang.ASTVisitor;
import com.sourceclear.sgl.lang.expr.EvaluatedArgument;
import com.sourceclear.sgl.lang.expr.EvaluatedArguments;
import com.sourceclear.sgl.lang.expr.Step;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.jetbrains.annotations.Nullable;

public abstract class GremlinTranslationVisitor
extends ASTVisitor<Void, Void, Object> {
    private final GraphTraversalSource source;
    private GraphTraversal<Vertex, Vertex> _traversal;
    private int var = 0;
    protected final Map<String, Step> env;

    private GremlinTranslationVisitor(GraphTraversalSource source, Map<String, Step> env) {
        this.source = source;
        this.env = env;
    }

    public GremlinTranslationVisitor(GraphTraversal<Vertex, Vertex> traversal, Map<String, Step> env) {
        this.source = null;
        this._traversal = traversal;
        this.env = env;
    }

    public GremlinTranslationVisitor(GraphTraversalSource source) {
        this(source, new HashMap<String, Step>());
    }

    public GremlinTranslationVisitor(GraphTraversal<Vertex, Vertex> traversal) {
        this(traversal, new HashMap<String, Step>());
    }

    protected String freshName() {
        return "v" + this.var++;
    }

    public static GraphTraversal<Vertex, Vertex> vertex(String vertexType, GraphTraversal<Vertex, Vertex> t, List<EvaluatedArgument<Object>> args) {
        EvaluatedArguments arguments = new EvaluatedArguments(args, Schema.getAllProperties(vertexType));
        if (arguments.isScan()) {
            return t.hasLabel(vertexType, new String[0]);
        }
        EvaluatedArguments.QueryType queryType = arguments.decideQueryType(Schema.getIndexedProperties(vertexType), Schema.getPartitionKeyProperties(vertexType));
        arguments.applySchemaDependentTransformations(queryType);
        switch (queryType) {
            case HAS_ID: {
                arguments.stripPredicates();
                return t.hasLabel(vertexType, new String[0]).hasId(GremlinTranslationVisitor.id(vertexType, arguments), new Object[0]);
            }
            case HAS: {
                return GremlinTranslationVisitor.vertexWithKeywordArgs(vertexType, t, arguments);
            }
        }
        throw new IllegalStateException();
    }

    static Map<String, Object> id(String vertexType, List<EvaluatedArgument<Object>> args) {
        EvaluatedArguments arguments = new EvaluatedArguments(args, Schema.getAllProperties(vertexType));
        EvaluatedArguments.QueryType queryType = arguments.decideQueryType(Schema.getIndexedProperties(vertexType), Schema.getPartitionKeyProperties(vertexType));
        switch (queryType) {
            case HAS_ID: {
                arguments.stripPredicates();
                return GremlinTranslationVisitor.id(vertexType, arguments);
            }
        }
        throw new IllegalStateException();
    }

    private static Map<String, Object> id(String vertexType, EvaluatedArguments arguments) {
        LinkedHashMap<String, Object> id = new LinkedHashMap<String, Object>();
        id.put("~label", vertexType);
        Schema.getPartitionKeyProperties(vertexType).forEach(p -> id.put("_" + p, arguments.get((String)p)));
        return id;
    }

    private static GraphTraversal<Vertex, Vertex> vertexWithKeywordArgs(String label, GraphTraversal<Vertex, Vertex> t, EvaluatedArguments args) {
        t.hasLabel(label, new String[0]);
        for (Map.Entry<String, Object> e : args.entrySet()) {
            t.has(e.getKey(), e.getValue());
        }
        return t;
    }

    protected GraphTraversal<Vertex, Vertex> traversal(@Nullable Function<GraphTraversalSource, GraphTraversal<Vertex, Vertex>> forSource, Consumer<GraphTraversal<Vertex, Vertex>> forTraversal) {
        if (this._traversal == null) {
            if (forSource == null) {
                throw new AssertionError((Object)"traversal is not present");
            }
            this._traversal = forSource.apply(this.source);
        } else {
            forTraversal.accept(this._traversal);
        }
        assert (this._traversal != null);
        return this._traversal;
    }

    protected GraphTraversal<Vertex, Vertex> traversal(Consumer<GraphTraversal<Vertex, Vertex>> forTraversal) {
        return this.traversal(null, forTraversal);
    }

    protected GraphTraversal<Vertex, Vertex> withTraversal(GraphTraversal<Vertex, Vertex> to, Runnable action) {
        GraphTraversal<Vertex, Vertex> temp = this._traversal;
        this._traversal = to;
        action.run();
        this._traversal = temp;
        return to;
    }

    public static Map<String, Object> constructId(String label, Object ... args) {
        if (args.length % 2 > 0) {
            throw new IllegalArgumentException("args " + Arrays.toString(args) + " must be of even length");
        }
        LinkedHashMap<String, Object> id = new LinkedHashMap<String, Object>();
        id.put("~label", label);
        for (int i = 0; i < args.length; i += 2) {
            if (!(args[i] instanceof String)) {
                throw new IllegalArgumentException("odd elements (property names) must be strings");
            }
            id.put((String)args[i], args[i + 1]);
        }
        return id;
    }

    protected Step resolveFreeVariables(Step step) {
        String name = step.getName();
        if (this.env.containsKey(name) && step.getArguments().isEmpty()) {
            Step bound = this.env.get(name);
            if (step.getNext().isPresent()) {
                return bound.concat(step.getNext().get());
            }
            return bound;
        }
        return step;
    }

    public GraphTraversal<Vertex, Vertex> getTraversal() {
        return this._traversal;
    }
}

