/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.sgl.lang;

import com.sourceclear.sgl.Edge;
import com.sourceclear.sgl.TinkerPop;
import com.sourceclear.sgl.lang.ExtractAddVisitor;
import com.sourceclear.sgl.lang.GremlinTranslationVisitor;
import com.sourceclear.sgl.lang.expr.Argument;
import com.sourceclear.sgl.lang.expr.Step;
import com.sourceclear.sgl.lang.expr.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class StepToTP {
    private final Graph graph;
    private final Map<Map<String, Object>, Vertex> seen = new HashMap<Map<String, Object>, Vertex>();

    public StepToTP(Graph graph) {
        this.graph = graph;
    }

    public ExtractAddVisitor<Vertex, Edge<Vertex>> visitor() {
        return new ExtractAddVisitor<Vertex, Edge<Vertex>>(new V(), new E());
    }

    private static Vertex safelyAddVertex(Graph graph, TinkerPop.VertexArgs args) {
        try {
            return graph.addVertex(args.args);
        }
        catch (IllegalArgumentException e) {
            return (Vertex)graph.traversal().V(new Object[]{args.id}).next();
        }
    }

    public class V
    implements Function<Step, Vertex> {
        @Override
        public Vertex apply(Step step) {
            String name = step.getName();
            List args = step.getArguments().stream().map(Argument::asValue).map(Value::getValue).collect(Collectors.toList());
            ArrayList<Object> props = new ArrayList<Object>();
            switch (name) {
                case "library": {
                    props.add(T.label);
                    props.add("library");
                    props.add(T.id);
                    props.add(GremlinTranslationVisitor.constructId("library", "_language", args.get(0), "_coord1", args.get(1), "_coord2", args.get(2), "_version", args.get(3)));
                    props.add("language");
                    props.add(args.get(0));
                    props.add("coord1");
                    props.add(args.get(1));
                    props.add("coord2");
                    props.add(args.get(2));
                    props.add("version");
                    props.add(args.get(3));
                    break;
                }
                case "library_hash": {
                    props.add(T.label);
                    props.add("library_hash");
                    props.add(T.id);
                    props.add(GremlinTranslationVisitor.constructId("library_hash", "_hash", args.get(0)));
                    props.add("hash");
                    props.add(args.get(0));
                    break;
                }
                case "file": {
                    props.add(T.label);
                    props.add("file");
                    props.add(T.id);
                    props.add(GremlinTranslationVisitor.constructId("file", "_language", args.get(0), "_coord1", args.get(1), "_coord2", args.get(2), "_version", args.get(3), "_name", args.get(4)));
                    props.add("name");
                    props.add(args.get(4));
                    break;
                }
                case "method_hash": {
                    props.add(T.label);
                    props.add("method_hash");
                    props.add(T.id);
                    props.add(GremlinTranslationVisitor.constructId("method_hash", "_length", args.get(0), "_hash", args.get(1)));
                    props.add("hash");
                    props.add(args.get(1));
                    break;
                }
                case "method": {
                    props.add(T.label);
                    props.add("method");
                    props.add(T.id);
                    props.add(GremlinTranslationVisitor.constructId("method", "_language", args.get(0), "_coord1", args.get(1), "_coord2", args.get(2), "_version", args.get(3), "_module_name", args.get(4), "_class_name", args.get(5), "_method_name", args.get(6), "_descriptor", args.get(7)));
                    props.add("module_name");
                    props.add(args.get(4));
                    props.add("class_name");
                    props.add(args.get(5));
                    props.add("method_name");
                    props.add(args.get(6));
                    props.add("descriptor");
                    props.add(args.get(7));
                    break;
                }
                case "class": {
                    props.add(T.label);
                    props.add("class");
                    props.add(T.id);
                    props.add(GremlinTranslationVisitor.constructId("class", "_language", args.get(0), "_coord1", args.get(1), "_coord2", args.get(2), "_version", args.get(3), "_name", args.get(4)));
                    props.add("name");
                    props.add(args.get(4));
                    break;
                }
                case "version_range": {
                    props.add(T.label);
                    props.add("version_range");
                    props.add(T.id);
                    props.add(GremlinTranslationVisitor.constructId("version_range", "_language", args.get(0), "_coord1", args.get(1), "_coord2", args.get(2), "_from", args.get(3), "_to", args.get(4)));
                    props.add("language");
                    props.add(args.get(0));
                    props.add("coord1");
                    props.add(args.get(1));
                    props.add("coord2");
                    props.add(args.get(2));
                    break;
                }
                case "vulnerability": {
                    props.add(T.label);
                    props.add("vulnerability");
                    props.add(T.id);
                    props.add(GremlinTranslationVisitor.constructId("vulnerability", "_cwe", args.get(0), "_query", args.get(1)));
                    props.add("cwe");
                    props.add(args.get(0));
                    break;
                }
                case "vulnerability_source": {
                    props.add(T.label);
                    props.add("vulnerability_source");
                    props.add(T.id);
                    props.add(GremlinTranslationVisitor.constructId("vulnerability_source", "_type", args.get(0), "_identity", args.get(1)));
                    props.add("description");
                    props.add(args.get(2));
                    props.add("released");
                    props.add(args.get(3));
                    break;
                }
                case "license": {
                    props.add(T.label);
                    props.add("license");
                    props.add(T.id);
                    props.add(GremlinTranslationVisitor.constructId("license", "_name", args.get(0)));
                    props.add("name");
                    props.add(args.get(0));
                    break;
                }
                case "variable": {
                    props.add(T.label);
                    props.add("variable");
                    props.add(T.id);
                    props.add(GremlinTranslationVisitor.constructId("variable", "_language", args.get(0), "_coord1", args.get(1), "_coord2", args.get(2), "_version", args.get(3), "_module_name", args.get(4), "_class_name", args.get(5), "_method_name", args.get(6), "_descriptor", args.get(7), "_name", args.get(8)));
                    props.add("language");
                    props.add(args.get(0));
                    props.add("coord1");
                    props.add(args.get(1));
                    props.add("coord2");
                    props.add(args.get(2));
                    props.add("version");
                    props.add(args.get(3));
                    props.add("module_name");
                    props.add(args.get(4));
                    props.add("class_name");
                    props.add(args.get(5));
                    props.add("method_name");
                    props.add(args.get(6));
                    props.add("descriptor");
                    props.add(args.get(7));
                    props.add("name");
                    props.add(args.get(8));
                    break;
                }
                default: {
                    throw new RuntimeException(String.format("Unknown vertex label %s", name));
                }
            }
            Object[] propValues = props.toArray();
            Map key = (Map)propValues[3];
            if (!StepToTP.this.seen.containsKey(key)) {
                Vertex vertex = StepToTP.safelyAddVertex(StepToTP.this.graph, new TinkerPop.VertexArgs(propValues, key));
                StepToTP.this.seen.put(key, vertex);
                return vertex;
            }
            return (Vertex)StepToTP.this.seen.get(key);
        }
    }

    public class E
    implements ExtractAddVisitor.Function4<String, Vertex, Vertex, Map<String, Object>, Edge<Vertex>> {
        @Override
        public Edge<Vertex> apply(String name, Vertex outVertex, Vertex inVertex, Map<String, Object> edgeArgs) {
            return new Edge<Vertex>(name, outVertex, inVertex, edgeArgs);
        }
    }
}

