/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.util.io.renderers;

import com.google.common.collect.Iterables;
import com.sourceclear.api.data.evidence.Coordinates;
import com.sourceclear.api.data.evidence.Evidence;
import com.sourceclear.api.data.evidence.EvidencePath;
import com.sourceclear.util.io.renderers.CoordinateCompator;
import com.sourceclear.util.io.renderers.Renderer;
import com.sourceclear.util.io.renderers.ScanReport;
import java.io.PrintStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListLibrariesRenderer
implements Renderer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListLibrariesRenderer.class);
    private final PrintStream out;

    public ListLibrariesRenderer(PrintStream out) {
        this(out, System.err);
    }

    public ListLibrariesRenderer(PrintStream out, PrintStream err) {
        this.out = out;
    }

    @Override
    public void accept(ScanReport item) {
        try {
            this.acceptEx(item);
        }
        catch (Exception e) {
            LOGGER.error("Unable to display library list: {}", (Object)e.getMessage());
        }
    }

    private void acceptEx(ScanReport item) throws Exception {
        CoordinateCompator compator = new CoordinateCompator();
        TreeMap<Coordinates, Set<Coordinates>> topLevel = new TreeMap<Coordinates, Set<Coordinates>>(compator);
        Collection<Evidence> evidence = item.getEvidence();
        if (Iterables.isEmpty(evidence)) {
            this.out.println("Unable to display library list without collected scan evidence");
            return;
        }
        for (Evidence evidence2 : evidence) {
            topLevel.putAll(ListLibrariesRenderer.getDependencyTreeFromEvidence(evidence2));
        }
        for (Map.Entry entry : topLevel.entrySet()) {
            this.out.printf("Direct: %s%n", ((Coordinates)entry.getKey()).toRawString());
            Set dependents = (Set)entry.getValue();
            for (Coordinates dep : dependents) {
                this.out.printf("\tTransitive: %s%n", dep.toRawString());
            }
        }
        this.out.println();
    }

    static Map<Coordinates, Set<Coordinates>> getDependencyTreeFromEvidence(Evidence evidence) {
        CoordinateCompator compator = new CoordinateCompator();
        TreeMap<Coordinates, Set<Coordinates>> results = new TreeMap<Coordinates, Set<Coordinates>>(compator);
        List<EvidencePath> paths = evidence.getEvidencePaths();
        if (Iterables.isEmpty(paths)) {
            return results;
        }
        Coordinates coord = evidence.getCoordinates();
        for (EvidencePath path : paths) {
            List<Coordinates> deps = path.getDependencyPath();
            if (Iterables.isEmpty(deps)) continue;
            for (Coordinates dep : deps) {
                TreeSet<Coordinates> children = (TreeSet<Coordinates>)results.get(dep);
                if (children == null) {
                    children = new TreeSet<Coordinates>(compator);
                    results.put(dep, children);
                }
                children.add(coord);
            }
        }
        return results;
    }
}

