/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.util.system;

import com.sourceclear.util.system.ComposerRequirementAssessor;
import com.sourceclear.util.system.NoRequirementsAssessor;
import com.sourceclear.util.system.SystemInfoResult;
import com.sourceclear.util.system.SystemInfoResults;
import com.sourceclear.util.system.SystemItemRequirementAssessor;
import com.sourceclear.util.system.SystemItemRequirementNotMetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public enum SystemItem {
    OS("OS", null, null, NoRequirementsAssessor.getInstance()),
    JAVA("Java", null, null, NoRequirementsAssessor.getInstance()),
    GIT("Git", "git", Pattern.compile("git version (?<version>\\S+).*?$", 32), NoRequirementsAssessor.getInstance()),
    MAVEN("Maven", "mvn", Pattern.compile("^Apache Maven (?<version>\\S+).*?$", 32), NoRequirementsAssessor.getInstance()),
    NPM("NPM", "npm", Pattern.compile("^(?<version>\\S+).*?$", 32), NoRequirementsAssessor.getInstance()),
    BUNDLER("Bundler", "bundler", Pattern.compile("^Bundler version (?<version>\\S+).*?$", 32), NoRequirementsAssessor.getInstance()),
    GEM("Gem", "gem", Pattern.compile("^(?<version>\\S+).*?$", 32), NoRequirementsAssessor.getInstance()),
    PYTHON("Python", "python", Pattern.compile("Python (?<version>\\S+).*?", 32), NoRequirementsAssessor.getInstance()),
    PIP("PIP", "pip", Pattern.compile("pip (?<version>\\S+).*?", 32), NoRequirementsAssessor.getInstance()),
    GRADLE("Gradle", "gradle", Pattern.compile(".+^Gradle (?<version>\\S+).*?$", 40), NoRequirementsAssessor.getInstance()),
    BOWER("Bower", "bower", Pattern.compile("^(?<version>\\S+).*?$", 32), NoRequirementsAssessor.getInstance()),
    ANT("Ant", "ant", Collections.singletonList("-version"), Pattern.compile("^Apache Ant\\(TM\\) version (?<version>\\S+).*?$", 32), NoRequirementsAssessor.getInstance()),
    YARN("Yarn", "yarn", Pattern.compile("^(?<version>\\S+).*?$", 32), NoRequirementsAssessor.getInstance()),
    COCOAPODS("CocoaPods", "pod", Pattern.compile("^(?<version>\\S+).*?$", 32), NoRequirementsAssessor.getInstance()),
    SBT("sbt", "sbt", Arrays.asList("-Dsbt.log.noformat=true", "sbtVersion"), Pattern.compile(".+\\[info\\] (?<version>\\S+).*?$", 32), NoRequirementsAssessor.getInstance()),
    GO("Go", "go", Arrays.asList("version"), Pattern.compile("^go version go(?<version>\\S+).*?$", 32), NoRequirementsAssessor.getInstance()),
    GLIDE("Glide", "glide", Arrays.asList("--version"), Pattern.compile("^glide version (?<version>\\S+).*?$", 32), NoRequirementsAssessor.getInstance()),
    TRASH("Trash", "trash", Arrays.asList("--version"), Pattern.compile("^trash version (?<version>\\S+).*?$", 32), NoRequirementsAssessor.getInstance()),
    GOVENDOR("Govendor", "govendor", Arrays.asList("-version"), Pattern.compile("^(?<version>\\S+).*?$", 32), NoRequirementsAssessor.getInstance()),
    GODEP("Godep", "godep", Arrays.asList("version"), Pattern.compile("^godep (?<version>\\S+).*?$", 32), NoRequirementsAssessor.getInstance()),
    DEP("Dep", "dep", Arrays.asList("version"), Pattern.compile("^dep:\\s*version\\s*:\\s*(?<version>\\S+).*?$", 40), NoRequirementsAssessor.getInstance()),
    PHP("PHP", "php", Pattern.compile("^PHP (?<version>\\S+).*?$", 40), ComposerRequirementAssessor.getInstance()),
    COMPOSER("Composer", "composer", Pattern.compile("^Composer version (?<version>\\S+).*?$", 32), ComposerRequirementAssessor.getInstance()),
    DOTNET("Dotnet", "dotnet", Pattern.compile("^(?<version>\\S+).*?$", 32), NoRequirementsAssessor.getInstance()),
    NUGET("Nuget", "nuget", Arrays.asList("help"), Pattern.compile("^NuGet Version: (?<version>\\S+).*?$", 40), NoRequirementsAssessor.getInstance()),
    MSBUILD("MSBuild", "msbuild", Arrays.asList("/version"), Pattern.compile("^Microsoft \\(R\\) Build Engine version (?<version>\\S+).*?$", 40), NoRequirementsAssessor.getInstance());

    private final String title;
    private final String executable;
    private final List<String> versionArgument;
    private final Pattern versionPattern;
    private final SystemItemRequirementAssessor requirementAssessor;
    private static final String DEFAULT_VERSION_ARGUMENT = "--version";

    private SystemItem(String title, String executable, Pattern versionPattern, SystemItemRequirementAssessor requirementAssessor) {
        this(title, executable, Collections.singletonList(DEFAULT_VERSION_ARGUMENT), versionPattern, requirementAssessor);
    }

    private SystemItem(String title, String executable, List<String> versionArgument, Pattern versionPattern, SystemItemRequirementAssessor requirementAssessor) {
        this.title = title;
        this.executable = executable;
        this.versionArgument = versionArgument;
        this.versionPattern = versionPattern;
        this.requirementAssessor = requirementAssessor;
    }

    public String toString() {
        return this.title;
    }

    public String getExecutable() {
        return this.executable;
    }

    public static List<SystemItem> getValuesWithExec() {
        ArrayList<SystemItem> valuesWithExec = new ArrayList<SystemItem>(SystemItem.values().length);
        for (SystemItem systemItem : SystemItem.values()) {
            if (systemItem.getExecutable() == null) continue;
            valuesWithExec.add(systemItem);
        }
        return valuesWithExec;
    }

    public Pattern getVersionPattern() {
        return this.versionPattern;
    }

    public List<String> getVersionArgument() {
        return this.versionArgument;
    }

    public void assess(SystemInfoResults results) throws SystemItemRequirementNotMetException {
        SystemInfoResult result = results.getItem(this);
        this.assess(result);
    }

    public void assess(SystemInfoResult result) throws SystemItemRequirementNotMetException {
        if (result == null || StringUtils.isBlank((CharSequence)result.getVersion())) {
            throw new SystemItemRequirementNotMetException(String.format("Couldn't find %s installation.", this.toString()));
        }
        this.requirementAssessor.assess(result);
    }
}

