/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.List;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.visitor.NodeVisitor;
import org.jrubyparser.lexer.yacc.ISourcePosition;

public class AliasNode
extends Node {
    private Node oldName;
    private Node newName;

    public AliasNode(ISourcePosition position, Node newName, Node oldName) {
        super(position, newName.containsVariableAssignment() || oldName.containsVariableAssignment());
        this.oldName = oldName;
        this.newName = newName;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ALIASNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitAliasNode(this);
    }

    public Node getNewName() {
        return this.newName;
    }

    public Node getOldName() {
        return this.oldName;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.newName, this.oldName);
    }
}

