/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.List;
import org.jrubyparser.ast.BlockAcceptingNode;
import org.jrubyparser.ast.EmptyArgsNode;
import org.jrubyparser.ast.IArgumentNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.types.INameNode;
import org.jrubyparser.ast.visitor.NodeVisitor;
import org.jrubyparser.lexer.yacc.ISourcePosition;

public class CallNode
extends Node
implements INameNode,
IArgumentNode,
BlockAcceptingNode {
    private final Node receiverNode;
    private Node argsNode;
    protected Node iterNode;
    private String name;
    private final boolean isLazy;

    public CallNode(ISourcePosition position, Node receiverNode, String name, Node argsNode, Node iterNode) {
        this(position, receiverNode, name, argsNode, iterNode, false);
    }

    public CallNode(ISourcePosition position, Node receiverNode, String name, Node argsNode, Node iterNode, boolean isLazy) {
        super(position, receiverNode.containsVariableAssignment() || argsNode != null && argsNode.containsVariableAssignment() || iterNode != null && iterNode.containsVariableAssignment());
        assert (receiverNode != null) : "receiverNode is not null";
        this.name = name;
        this.receiverNode = receiverNode;
        this.argsNode = argsNode != null ? argsNode : new EmptyArgsNode();
        this.iterNode = iterNode;
        this.isLazy = isLazy;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.CALLNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitCallNode(this);
    }

    @Override
    public Node getIterNode() {
        return this.iterNode;
    }

    @Override
    public Node setIterNode(Node iterNode) {
        this.iterNode = iterNode;
        return this;
    }

    @Override
    public Node getArgsNode() {
        return this.argsNode;
    }

    @Override
    public Node setArgsNode(Node argsNode) {
        this.argsNode = argsNode;
        return argsNode;
    }

    public String getLexicalName() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Node getReceiverNode() {
        return this.receiverNode;
    }

    public boolean isLazy() {
        return this.isLazy;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.receiverNode, this.argsNode, this.iterNode);
    }

    @Override
    protected String toStringInternal() {
        return this.isLazy ? "lazy" : null;
    }
}

