/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.List;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.visitor.NodeVisitor;
import org.jrubyparser.lexer.yacc.ISourcePosition;

public class IfNode
extends Node {
    private final Node condition;
    private final Node thenBody;
    private final Node elseBody;

    public IfNode(ISourcePosition position, Node condition, Node thenBody, Node elseBody) {
        super(position, condition.containsVariableAssignment || thenBody != null && thenBody.containsVariableAssignment || elseBody != null && elseBody.containsVariableAssignment);
        assert (condition != null) : "condition is not null";
        this.condition = condition;
        this.thenBody = thenBody;
        this.elseBody = elseBody;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.IFNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitIfNode(this);
    }

    public Node getCondition() {
        return this.condition;
    }

    public Node getElseBody() {
        return this.elseBody;
    }

    public Node getThenBody() {
        return this.thenBody;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.condition, this.thenBody, this.elseBody);
    }
}

