/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.List;
import org.jrubyparser.ast.IScopedNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.SideEffectFree;
import org.jrubyparser.ast.types.INameNode;
import org.jrubyparser.ast.visitor.NodeVisitor;
import org.jrubyparser.lexer.yacc.ISourcePosition;

public class LocalVarNode
extends Node
implements INameNode,
IScopedNode,
SideEffectFree {
    private String name;
    private final int location;

    public LocalVarNode(ISourcePosition position, int location, String name) {
        super(position, false);
        this.location = location;
        this.name = name;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.LOCALVARNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitLocalVarNode(this);
    }

    @Override
    public int getDepth() {
        return this.location >> 16;
    }

    @Override
    public int getIndex() {
        return this.location & 0xFFFF;
    }

    public String getLexicalName() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    @Override
    public boolean needsDefinitionCheck() {
        return false;
    }
}

