/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.List;
import org.jrubyparser.ast.BinaryOperatorNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.visitor.NodeVisitor;
import org.jrubyparser.lexer.yacc.ISourcePosition;

public class OpAsgnAndNode
extends Node
implements BinaryOperatorNode {
    private final Node firstNode;
    private final Node secondNode;

    public OpAsgnAndNode(ISourcePosition position, Node headNode, Node valueNode) {
        super(position, headNode.containsVariableAssignment() || valueNode.containsVariableAssignment());
        assert (headNode != null) : "headNode is not null";
        assert (valueNode != null) : "valueNode is not null";
        this.firstNode = headNode;
        this.secondNode = valueNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.OPASGNANDNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitOpAsgnAndNode(this);
    }

    @Override
    public Node getFirstNode() {
        return this.firstNode;
    }

    @Override
    public Node getSecondNode() {
        return this.secondNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.firstNode, this.secondNode);
    }
}

