/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.List;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.visitor.NodeVisitor;
import org.jrubyparser.lexer.yacc.ISourcePosition;
import org.jrubyparser.parser.StaticScope;

public class RootNode
extends Node {
    private StaticScope staticScope;
    private Node bodyNode;
    private String file;
    private int endPosition;
    private boolean needsCodeCoverage;

    public RootNode(ISourcePosition position, StaticScope scope, Node bodyNode, String file) {
        this(position, scope, bodyNode, file, -1, false);
    }

    public RootNode(ISourcePosition position, StaticScope scope, Node bodyNode, String file, int endPosition, boolean needsCodeCoverage) {
        super(position, bodyNode.containsVariableAssignment());
        this.staticScope = scope;
        this.bodyNode = bodyNode;
        this.file = file;
        this.endPosition = endPosition;
        this.needsCodeCoverage = needsCodeCoverage;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ROOTNODE;
    }

    public StaticScope getStaticScope() {
        return this.staticScope;
    }

    public String getFile() {
        return this.file;
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitRootNode(this);
    }

    @Override
    public List<Node> childNodes() {
        return RootNode.createList(this.bodyNode);
    }

    public boolean hasEndPosition() {
        return this.endPosition != -1;
    }

    public int getEndPosition() {
        return this.endPosition;
    }

    public boolean needsCoverage() {
        return this.needsCodeCoverage;
    }
}

