/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.List;
import org.jruby.util.ByteList;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.SideEffectFree;
import org.jrubyparser.ast.types.ILiteralNode;
import org.jrubyparser.ast.visitor.NodeVisitor;
import org.jrubyparser.lexer.yacc.ISourcePosition;
import org.jrubyparser.util.StringSupport;

public class StrNode
extends Node
implements ILiteralNode,
SideEffectFree {
    private final ByteList value;
    private final int codeRange;
    private boolean frozen;

    public StrNode(ISourcePosition position, ByteList value) {
        this(position, value, StringSupport.codeRangeScan(value.getEncoding(), value));
    }

    public StrNode(ISourcePosition position, ByteList value, int codeRange) {
        super(position, false);
        this.value = value;
        this.codeRange = codeRange;
    }

    public StrNode(ISourcePosition position, StrNode head, StrNode tail) {
        super(position, false);
        ByteList headBL = head.getValue();
        ByteList tailBL = tail.getValue();
        ByteList myValue = new ByteList(headBL.getRealSize() + tailBL.getRealSize());
        myValue.setEncoding(headBL.getEncoding());
        myValue.append(headBL);
        myValue.append(tailBL);
        this.frozen = head.isFrozen() && tail.isFrozen();
        this.value = myValue;
        this.codeRange = StringSupport.codeRangeScan(this.value.getEncoding(), this.value);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.STRNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitStrNode(this);
    }

    public ByteList getValue() {
        return this.value;
    }

    public int getCodeRange() {
        return this.codeRange;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
    }
}

