/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.runtime.encoding;

import org.jcodings.Encoding;
import org.jcodings.EncodingDB;
import org.jcodings.util.CaseInsensitiveBytesHash;
import org.jruby.util.ByteList;
import org.jrubyparser.RubyEncoding;

public final class EncodingService {
    private final CaseInsensitiveBytesHash<EncodingDB.Entry> encodings;
    private final CaseInsensitiveBytesHash<EncodingDB.Entry> aliases;
    public final RubyEncoding[] encodingList;
    private RubyEncoding[] encodingIndex = new RubyEncoding[4];

    public EncodingService() {
        this.encodings = EncodingDB.getEncodings();
        this.aliases = EncodingDB.getAliases();
        this.encodingList = new RubyEncoding[this.encodings.size()];
    }

    public EncodingDB.Entry findEncodingEntry(ByteList bytes) {
        return (EncodingDB.Entry)this.encodings.get(bytes.getUnsafeBytes(), bytes.getBegin(), bytes.getBegin() + bytes.getRealSize());
    }

    public EncodingDB.Entry findAliasEntry(ByteList bytes) {
        return (EncodingDB.Entry)this.aliases.get(bytes.getUnsafeBytes(), bytes.getBegin(), bytes.getBegin() + bytes.getRealSize());
    }

    public EncodingDB.Entry findEncodingOrAliasEntry(ByteList bytes) {
        EncodingDB.Entry e = this.findEncodingEntry(bytes);
        return e != null ? e : this.findAliasEntry(bytes);
    }

    public Encoding loadEncoding(ByteList name) {
        EncodingDB.Entry entry = this.findEncodingOrAliasEntry(name);
        if (entry == null) {
            return null;
        }
        Encoding enc = entry.getEncoding();
        int index = enc.getIndex();
        if (index >= this.encodingIndex.length) {
            RubyEncoding[] tmp = new RubyEncoding[index + 4];
            System.arraycopy(this.encodingIndex, 0, tmp, 0, this.encodingIndex.length);
            this.encodingIndex = tmp;
        }
        this.encodingIndex[index] = this.encodingList[entry.getIndex()];
        return enc;
    }

    public RubyEncoding getEncoding(Encoding enc) {
        RubyEncoding rubyEncoding;
        int index = enc.getIndex();
        if (index < this.encodingIndex.length && (rubyEncoding = this.encodingIndex[index]) != null) {
            return rubyEncoding;
        }
        enc = this.loadEncoding(new ByteList(enc.getName(), false));
        return this.encodingIndex[enc.getIndex()];
    }
}

