/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.collect.ImmutableMap;
import com.sourceclear.api.data.HATEOASApiModel;
import com.sourceclear.api.data.LicenseData_Limits_Builder;
import com.sourceclear.api.data.LicenseData_Usage_Builder;
import com.sourceclear.api.data.LicenseStatus;
import com.sourceclear.api.data.Link;
import com.sourceclear.api.data.PlanType;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=Builder.class)
@Immutable
public class LicenseData
extends HATEOASApiModel {
    private static final long serialVersionUID = 1L;
    public static final String FEATURE_COMPONENT_SCANNING = "componentScan";
    public static final String FEATURE_VULN_METHODS_SCANNING = "vulnMethodsScan";
    public static final String FEATURE_TWO_FACTOR_AUTH = "twoFactorAuth";
    public static final String FEATURE_ENTERPRISE_REPO = "enterpriseRepoScan";
    public static final String FEATURE_ENTERPRISE_CONTAINER = "enterpriseContainerScan";
    private final PlanType planType;
    private final boolean canTrial;
    private final Date trialStartDate;
    private final Date trialEndDate;
    private final ImmutableMap<String, Boolean> features;
    private final LicenseStatus status;
    private final String statusMessage;
    private final Usage usage;
    private final Limits limits;

    private LicenseData(Builder builder) {
        this.planType = builder.planType;
        this.canTrial = builder.canTrial;
        this.trialStartDate = builder.trialStartDate;
        this.trialEndDate = builder.trialEndDate;
        this.features = ImmutableMap.copyOf((Map)builder.features);
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.usage = builder.usage;
        this.limits = builder.limits;
        for (Link link : builder.linkObjectList) {
            this.addLink(link);
        }
        for (Map.Entry entry : builder.links.entrySet()) {
            this.addLink((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public PlanType getPlanType() {
        return this.planType;
    }

    public ImmutableMap<String, Boolean> getFeatures() {
        return this.features;
    }

    public boolean getCanTrial() {
        return this.canTrial;
    }

    @Nullable
    public Date getTrialStartDate() {
        return this.trialStartDate;
    }

    @Nullable
    public Date getTrialEndDate() {
        return this.trialEndDate;
    }

    @Nonnull
    public LicenseStatus getStatus() {
        return this.status;
    }

    @Nullable
    public String getStatusMessage() {
        return this.statusMessage;
    }

    @Nullable
    public Usage getUsage() {
        return this.usage;
    }

    @Nullable
    public Limits getLimits() {
        return this.limits;
    }

    @JsonDeserialize(builder=Builder.class)
    public static interface Limits {
        @Nullable
        public Integer getRepos();

        @Nullable
        public Integer getUsers();

        @Nullable
        public Integer getTeams();

        @Nullable
        public Integer getScans();

        public static class Builder
        extends LicenseData_Limits_Builder {
        }
    }

    @JsonDeserialize(builder=Builder.class)
    public static abstract class Usage {
        public abstract int getRepos();

        public abstract int getUsers();

        public abstract int getTeams();

        public abstract int getScans();

        public boolean withinLimits(Limits limits) {
            Integer repoLimit = limits.getRepos();
            if (repoLimit != null && this.getRepos() > repoLimit) {
                return false;
            }
            Integer userLimit = limits.getUsers();
            if (userLimit != null && this.getUsers() > userLimit) {
                return false;
            }
            Integer teamLimit = limits.getTeams();
            if (teamLimit != null && this.getTeams() > teamLimit) {
                return false;
            }
            Integer scanLimit = limits.getScans();
            return scanLimit == null || this.getScans() <= scanLimit;
        }

        public static class Builder
        extends LicenseData_Usage_Builder {
        }
    }

    public static class Builder {
        private PlanType planType;
        private boolean canTrial;
        private Date trialStartDate;
        private Date trialEndDate;
        private Map<String, Boolean> features = new TreeMap<String, Boolean>();
        private List<Link> linkObjectList = new ArrayList<Link>();
        private LicenseStatus status = LicenseStatus.NONE;
        private String statusMessage;
        private Limits limits;
        private Usage usage;
        private Map<String, String> links = new LinkedHashMap<String, String>();

        public Builder withPlanType(PlanType planType) {
            this.planType = planType;
            return this;
        }

        public Builder withCanTrial(boolean canTrial) {
            this.canTrial = canTrial;
            return this;
        }

        public Builder withTrialStartDate(Date trialStartDate) {
            this.trialStartDate = trialStartDate;
            return this;
        }

        public Builder withTrialEndDate(Date trialEndDate) {
            this.trialEndDate = trialEndDate;
            return this;
        }

        public Builder withFeatures(Map<String, Boolean> features) {
            this.features = features;
            return this;
        }

        public Builder withFeature(String feature, boolean enabled) {
            this.features.put(feature, enabled);
            return this;
        }

        public Builder withLink(Link link) {
            this.linkObjectList.add(link);
            return this;
        }

        public Builder withLinks(Map<String, String> links) {
            this.links = links;
            return this;
        }

        public Builder withStatus(LicenseStatus status) {
            this.status = Objects.requireNonNull(status, "cannot set license status to null");
            return this;
        }

        public Builder withStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public Builder withUsage(Usage usage) {
            this.usage = usage;
            return this;
        }

        public Builder withLimits(Limits limits) {
            this.limits = limits;
            return this;
        }

        public LicenseData build() {
            return new LicenseData(this);
        }
    }
}

