/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.events;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.sourceclear.api.data.events.IssueModel;
import com.sourceclear.api.data.issues.IssueType;
import java.net.URI;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.function.LongUnaryOperator;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;

abstract class IssueModel_Builder {
    private IssueType type;
    private long id;
    private IssueModel.IssueStatus status;
    private URI issueUrl = null;
    private final EnumSet<Property> _unsetProperties = EnumSet.allOf(Property.class);

    IssueModel_Builder() {
    }

    public static IssueModel.Builder from(IssueModel value) {
        if (value instanceof Rebuildable) {
            return ((Rebuildable)value).toBuilder();
        }
        return new IssueModel.Builder().mergeFrom(value);
    }

    @JsonProperty(value="type")
    public IssueModel.Builder setType(IssueType type) {
        this.type = Objects.requireNonNull(type);
        this._unsetProperties.remove((Object)Property.TYPE);
        return (IssueModel.Builder)this;
    }

    public IssueModel.Builder mapType(UnaryOperator<IssueType> mapper) {
        Objects.requireNonNull(mapper);
        return this.setType((IssueType)((Object)mapper.apply(this.getType())));
    }

    public IssueType getType() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.TYPE) ? 1 : 0) != 0, (Object)"type not set");
        return this.type;
    }

    @JsonProperty(value="id")
    public IssueModel.Builder setId(long id) {
        this.id = id;
        this._unsetProperties.remove((Object)Property.ID);
        return (IssueModel.Builder)this;
    }

    public IssueModel.Builder mapId(LongUnaryOperator mapper) {
        Objects.requireNonNull(mapper);
        return this.setId(mapper.applyAsLong(this.getId()));
    }

    public long getId() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.ID) ? 1 : 0) != 0, (Object)"id not set");
        return this.id;
    }

    @JsonProperty(value="status")
    public IssueModel.Builder setStatus(IssueModel.IssueStatus status) {
        this.status = Objects.requireNonNull(status);
        this._unsetProperties.remove((Object)Property.STATUS);
        return (IssueModel.Builder)this;
    }

    public IssueModel.Builder mapStatus(UnaryOperator<IssueModel.IssueStatus> mapper) {
        Objects.requireNonNull(mapper);
        return this.setStatus((IssueModel.IssueStatus)((Object)mapper.apply(this.getStatus())));
    }

    public IssueModel.IssueStatus getStatus() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.STATUS) ? 1 : 0) != 0, (Object)"status not set");
        return this.status;
    }

    public IssueModel.Builder setIssueUrl(URI issueUrl) {
        this.issueUrl = Objects.requireNonNull(issueUrl);
        return (IssueModel.Builder)this;
    }

    @JsonProperty(value="issueUrl")
    public IssueModel.Builder setIssueUrl(Optional<? extends URI> issueUrl) {
        if (issueUrl.isPresent()) {
            return this.setIssueUrl(issueUrl.get());
        }
        return this.clearIssueUrl();
    }

    public IssueModel.Builder setNullableIssueUrl(@Nullable URI issueUrl) {
        if (issueUrl != null) {
            return this.setIssueUrl(issueUrl);
        }
        return this.clearIssueUrl();
    }

    public IssueModel.Builder mapIssueUrl(UnaryOperator<URI> mapper) {
        return this.setIssueUrl(this.getIssueUrl().map(mapper));
    }

    public IssueModel.Builder clearIssueUrl() {
        this.issueUrl = null;
        return (IssueModel.Builder)this;
    }

    public Optional<URI> getIssueUrl() {
        return Optional.ofNullable(this.issueUrl);
    }

    public IssueModel.Builder mergeFrom(IssueModel value) {
        IssueModel.Builder defaults = new IssueModel.Builder();
        if (defaults._unsetProperties.contains((Object)Property.TYPE) || !Objects.equals((Object)value.getType(), (Object)((IssueModel_Builder)defaults).getType())) {
            this.setType(value.getType());
        }
        if (defaults._unsetProperties.contains((Object)Property.ID) || value.getId() != ((IssueModel_Builder)defaults).getId()) {
            this.setId(value.getId());
        }
        if (defaults._unsetProperties.contains((Object)Property.STATUS) || !Objects.equals((Object)value.getStatus(), (Object)((IssueModel_Builder)defaults).getStatus())) {
            this.setStatus(value.getStatus());
        }
        value.getIssueUrl().ifPresent(this::setIssueUrl);
        return (IssueModel.Builder)this;
    }

    public IssueModel.Builder mergeFrom(IssueModel.Builder template) {
        IssueModel.Builder base = template;
        IssueModel.Builder defaults = new IssueModel.Builder();
        if (!(base._unsetProperties.contains((Object)Property.TYPE) || !defaults._unsetProperties.contains((Object)Property.TYPE) && Objects.equals((Object)template.getType(), (Object)((IssueModel_Builder)defaults).getType()))) {
            this.setType(template.getType());
        }
        if (!base._unsetProperties.contains((Object)Property.ID) && (defaults._unsetProperties.contains((Object)Property.ID) || template.getId() != ((IssueModel_Builder)defaults).getId())) {
            this.setId(template.getId());
        }
        if (!(base._unsetProperties.contains((Object)Property.STATUS) || !defaults._unsetProperties.contains((Object)Property.STATUS) && Objects.equals((Object)template.getStatus(), (Object)((IssueModel_Builder)defaults).getStatus()))) {
            this.setStatus(template.getStatus());
        }
        template.getIssueUrl().ifPresent(this::setIssueUrl);
        return (IssueModel.Builder)this;
    }

    public IssueModel.Builder clear() {
        IssueModel.Builder defaults = new IssueModel.Builder();
        this.type = defaults.type;
        this.id = defaults.id;
        this.status = defaults.status;
        this.issueUrl = defaults.issueUrl;
        this._unsetProperties.clear();
        this._unsetProperties.addAll(defaults._unsetProperties);
        return (IssueModel.Builder)this;
    }

    public IssueModel build() {
        Preconditions.checkState((boolean)this._unsetProperties.isEmpty(), (String)"Not set: %s", this._unsetProperties);
        return new Value(this);
    }

    @VisibleForTesting
    public IssueModel buildPartial() {
        return new Partial(this);
    }

    private static final class Partial
    extends Rebuildable {
        private final IssueType type;
        private final long id;
        private final IssueModel.IssueStatus status;
        private final URI issueUrl;
        private final EnumSet<Property> _unsetProperties;

        Partial(IssueModel_Builder builder) {
            this.type = builder.type;
            this.id = builder.id;
            this.status = builder.status;
            this.issueUrl = builder.issueUrl;
            this._unsetProperties = builder._unsetProperties.clone();
        }

        @Override
        @JsonProperty(value="type")
        public IssueType getType() {
            if (this._unsetProperties.contains((Object)Property.TYPE)) {
                throw new UnsupportedOperationException("type not set");
            }
            return this.type;
        }

        @Override
        @JsonProperty(value="id")
        public long getId() {
            if (this._unsetProperties.contains((Object)Property.ID)) {
                throw new UnsupportedOperationException("id not set");
            }
            return this.id;
        }

        @Override
        @JsonProperty(value="status")
        public IssueModel.IssueStatus getStatus() {
            if (this._unsetProperties.contains((Object)Property.STATUS)) {
                throw new UnsupportedOperationException("status not set");
            }
            return this.status;
        }

        @Override
        @JsonProperty(value="issueUrl")
        public Optional<URI> getIssueUrl() {
            return Optional.ofNullable(this.issueUrl);
        }

        @Override
        public IssueModel.Builder toBuilder() {
            PartialBuilder builder = new PartialBuilder();
            ((IssueModel_Builder)builder).type = this.type;
            ((IssueModel_Builder)builder).id = this.id;
            ((IssueModel_Builder)builder).status = this.status;
            ((IssueModel_Builder)builder).issueUrl = this.issueUrl;
            ((IssueModel_Builder)builder)._unsetProperties.clear();
            ((IssueModel_Builder)builder)._unsetProperties.addAll(this._unsetProperties);
            return builder;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)obj;
            return Objects.equals((Object)this.type, (Object)other.type) && this.id == other.id && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.issueUrl, other.issueUrl) && Objects.equals(this._unsetProperties, other._unsetProperties);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.id, this.status, this.issueUrl, this._unsetProperties});
        }

        public String toString() {
            StringBuilder result = new StringBuilder("partial IssueModel{");
            String separator = "";
            if (!this._unsetProperties.contains((Object)Property.TYPE)) {
                result.append("type=").append((Object)this.type);
                separator = ", ";
            }
            if (!this._unsetProperties.contains((Object)Property.ID)) {
                result.append(separator).append("id=").append(this.id);
                separator = ", ";
            }
            if (!this._unsetProperties.contains((Object)Property.STATUS)) {
                result.append(separator).append("status=").append((Object)this.status);
                separator = ", ";
            }
            if (this.issueUrl != null) {
                result.append(separator).append("issueUrl=").append(this.issueUrl);
            }
            return result.append("}").toString();
        }

        private static class PartialBuilder
        extends IssueModel.Builder {
            private PartialBuilder() {
            }

            @Override
            public IssueModel build() {
                return this.buildPartial();
            }
        }
    }

    private static final class Value
    extends Rebuildable {
        private final IssueType type;
        private final long id;
        private final IssueModel.IssueStatus status;
        private final URI issueUrl;

        private Value(IssueModel_Builder builder) {
            this.type = builder.type;
            this.id = builder.id;
            this.status = builder.status;
            this.issueUrl = builder.issueUrl;
        }

        @Override
        @JsonProperty(value="type")
        public IssueType getType() {
            return this.type;
        }

        @Override
        @JsonProperty(value="id")
        public long getId() {
            return this.id;
        }

        @Override
        @JsonProperty(value="status")
        public IssueModel.IssueStatus getStatus() {
            return this.status;
        }

        @Override
        @JsonProperty(value="issueUrl")
        public Optional<URI> getIssueUrl() {
            return Optional.ofNullable(this.issueUrl);
        }

        @Override
        public IssueModel.Builder toBuilder() {
            IssueModel.Builder builder = new IssueModel.Builder();
            ((IssueModel_Builder)builder).type = this.type;
            ((IssueModel_Builder)builder).id = this.id;
            ((IssueModel_Builder)builder).status = this.status;
            ((IssueModel_Builder)builder).issueUrl = this.issueUrl;
            ((IssueModel_Builder)builder)._unsetProperties.clear();
            return builder;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            return Objects.equals((Object)this.type, (Object)other.type) && this.id == other.id && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.issueUrl, other.issueUrl);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.id, this.status, this.issueUrl});
        }

        public String toString() {
            StringBuilder result = new StringBuilder("IssueModel{type=").append((Object)this.type).append(", id=").append(this.id).append(", status=").append((Object)this.status);
            if (this.issueUrl != null) {
                result.append(", issueUrl=").append(this.issueUrl);
            }
            return result.append("}").toString();
        }
    }

    private static abstract class Rebuildable
    implements IssueModel {
        private Rebuildable() {
        }

        public abstract IssueModel.Builder toBuilder();
    }

    private static enum Property {
        TYPE("type"),
        ID("id"),
        STATUS("status");

        private final String name;

        private Property(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

