/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.evidence;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.sourceclear.api.data.evidence.CaseInsensitiveCoordNormalizer;
import com.sourceclear.api.data.evidence.CoordNormalizer;
import com.sourceclear.api.data.evidence.IdentityNormalizer;
import com.sourceclear.api.data.evidence.LanguageType;
import com.sourceclear.api.data.evidence.PythonCoordNormalizer;

public enum CoordinateType {
    MAVEN("Maven", 2, "", IdentityNormalizer.getSingleton(), LanguageType.JAVA),
    GEM("GEM", 1, "ruby", IdentityNormalizer.getSingleton(), LanguageType.RUBY),
    NPM("NPM", 1, "", IdentityNormalizer.getSingleton(), LanguageType.JS),
    BOWER("BOWER", 1, "", IdentityNormalizer.getSingleton(), LanguageType.JS),
    PYPI("PYPI", 1, "source", PythonCoordNormalizer.getSingleton(), LanguageType.PYTHON),
    COCOAPODS("COCOAPODS", 1, "", IdentityNormalizer.getSingleton(), LanguageType.OBJECTIVEC),
    GO("GO", 1, "", CaseInsensitiveCoordNormalizer.getSingleton(), LanguageType.GO),
    PACKAGIST("PACKAGIST", 1, "", CaseInsensitiveCoordNormalizer.getSingleton(), LanguageType.PHP),
    SO("SO", 1, "", IdentityNormalizer.getSingleton(), LanguageType.CPP),
    NUGET("NUGET", 1, "", CaseInsensitiveCoordNormalizer.getSingleton(), LanguageType.CSHARP),
    RPM("RPM", 1, "", CaseInsensitiveCoordNormalizer.getSingleton(), LanguageType.OS),
    ALPINE("ALPINE", 2, "", IdentityNormalizer.getSingleton(), LanguageType.OS),
    DOTNETCORE("DOTNETCORE", 1, "", IdentityNormalizer.getSingleton(), LanguageType.CSHARP),
    DEBIAN("DEBIAN", 2, "", CaseInsensitiveCoordNormalizer.getSingleton(), LanguageType.OS),
    MANUAL("MANUAL", 2, "", IdentityNormalizer.getSingleton(), LanguageType.JAVA);

    private final String name;
    private final int coordinateCount;
    private final String defaultPlatformName;
    private CoordNormalizer normalizer;
    private final LanguageType primaryLanguage;

    private CoordinateType(String name, int coordinateCount, String defaultPlatformName, CoordNormalizer normalizer, LanguageType primaryLanguage) {
        this.name = name;
        this.coordinateCount = coordinateCount;
        this.defaultPlatformName = defaultPlatformName;
        this.normalizer = normalizer;
        this.primaryLanguage = primaryLanguage;
    }

    public int getCoordinateCount() {
        return this.coordinateCount;
    }

    public String getName() {
        return this.name;
    }

    public String getDefaultPlatformName() {
        return this.defaultPlatformName;
    }

    public LanguageType getPrimaryLanguage() {
        return this.primaryLanguage;
    }

    public CoordNormalizer getNormalizer() {
        return this.normalizer;
    }

    @JsonCreator
    public static CoordinateType toCoordType(String strVal) {
        if (strVal == null) {
            return null;
        }
        String upperVal = strVal.toUpperCase();
        return CoordinateType.valueOf(upperVal);
    }
}

