/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.common;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.sourceclear.api.data.analytics.AgentRuntimeData;
import com.sourceclear.api.data.evidence.Evidence;
import com.sourceclear.util.io.EvidenceUtils;
import com.srcclr.sdk.LibraryGraphContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CollectionResult {
    @Nullable
    private final LibraryGraphContainer graphs;
    private final ImmutableMap<String, Object> scanAttributes;
    private final ImmutableSet<Evidence> evidence;
    private final int filesScanned;
    private final boolean methodsSupported;
    private final Long lineCount;
    private final AgentRuntimeData agentRuntimeData;
    private final List<Advice> advice;
    private final boolean noDependencyGraph;

    private CollectionResult(Builder builder) {
        this.graphs = builder.graphs;
        this.noDependencyGraph = builder.noDependencyGraph;
        this.evidence = this.graphs != null ? ImmutableSet.copyOf(EvidenceUtils.evidenceFromLibraryGraphs(this.graphs.getGraphs(), this.noDependencyGraph)) : ImmutableSet.of();
        this.scanAttributes = builder.scanAttributes;
        this.filesScanned = builder.filesScanned;
        this.methodsSupported = builder.methodsSupported;
        this.lineCount = builder.lineCount;
        this.agentRuntimeData = builder.agentRuntimeData;
        this.advice = builder.advice;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CollectionResult that = (CollectionResult)o;
        return this.filesScanned == that.filesScanned && this.methodsSupported == that.methodsSupported && Objects.equals(this.graphs, that.graphs) && Objects.equals(this.scanAttributes, that.scanAttributes) && Objects.equals(this.evidence, that.evidence) && Objects.equals(this.lineCount, that.lineCount) && Objects.equals(this.agentRuntimeData, that.agentRuntimeData) && Objects.equals(this.advice, that.advice);
    }

    public int hashCode() {
        return Objects.hash(this.graphs, this.scanAttributes, this.evidence, this.filesScanned, this.methodsSupported, this.lineCount, this.agentRuntimeData, this.advice);
    }

    public String toString() {
        return "CollectionResult{graphs=" + this.graphs + ", scanAttributes=" + this.scanAttributes + ", evidence=" + this.evidence + ", filesScanned=" + this.filesScanned + ", methodsSupported=" + this.methodsSupported + ", lineCount=" + this.lineCount + ", agentRuntimeData=" + this.agentRuntimeData + ", advice=" + this.advice + '}';
    }

    public ImmutableSet<Evidence> getEvidence() {
        return this.evidence;
    }

    public ImmutableMap<String, Object> getScanAttributes() {
        return this.scanAttributes;
    }

    public int getFilesScanned() {
        return this.filesScanned;
    }

    public boolean isMethodsSupported() {
        return this.methodsSupported;
    }

    public Long getLineCount() {
        return this.lineCount;
    }

    @Nullable
    public LibraryGraphContainer getGraphs() {
        return this.graphs;
    }

    @Nullable
    public AgentRuntimeData getAgentRuntimeData() {
        return this.agentRuntimeData;
    }

    public List<Advice> getAdvice() {
        return this.advice;
    }

    public static class Builder {
        private LibraryGraphContainer graphs = null;
        private int filesScanned = 0;
        private boolean methodsSupported = false;
        private Long lineCount;
        private ImmutableMap<String, Object> scanAttributes = ImmutableMap.of();
        private AgentRuntimeData agentRuntimeData;
        private List<Advice> advice = new ArrayList<Advice>();
        private boolean noDependencyGraph = false;

        public Builder withScanAttributes(ImmutableMap<String, Object> scanAttributes) {
            this.scanAttributes = scanAttributes;
            return this;
        }

        public Builder withGraphs(LibraryGraphContainer graphs) {
            this.graphs = graphs;
            return this;
        }

        public Builder withFilesScanned(int filesScanned) {
            this.filesScanned += filesScanned;
            return this;
        }

        public Builder withLineCount(long lineCount) {
            this.lineCount = this.lineCount == null ? lineCount : this.lineCount + lineCount;
            return this;
        }

        public Builder withMethodsSupported(boolean methodsSupported) {
            this.methodsSupported = methodsSupported;
            return this;
        }

        public Builder withAgentRuntimeData(AgentRuntimeData agentRuntimeData) {
            this.agentRuntimeData = agentRuntimeData;
            return this;
        }

        public Builder withAdvice(@Nonnull List<Advice> advice) {
            this.advice = advice;
            return this;
        }

        public Builder noDependencyGraph(boolean noDependencyGraph) {
            this.noDependencyGraph = noDependencyGraph;
            return this;
        }

        public CollectionResult build() {
            return new CollectionResult(this);
        }
    }

    public static class Advice {
        private final String collectorName;
        private final String advice;

        public Advice(String name, String advice) {
            this.collectorName = name;
            this.advice = advice;
        }

        public String getCollectorName() {
            return this.collectorName;
        }

        public String getAdvice() {
            return this.advice;
        }
    }
}

