/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.methods;

import com.sourceclear.methods.CallSite;
import com.sourceclear.methods.JGCallGraph;
import com.sourceclear.methods.MethodInfo;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.graph.DirectedPseudograph;
import org.jgrapht.graph.EdgeReversedGraph;
import org.jgrapht.traverse.CrossComponentIterator;

public class JGReachabilityInspector {
    private final JGCallGraph callGraph;

    JGReachabilityInspector(JGCallGraph callGraph) {
        this.callGraph = callGraph;
    }

    public Set<MethodInfo> findPossibleCallers(Set<MethodInfo> targets, Set<MethodInfo> entry) {
        HashSet<MethodInfo> result = new HashSet<MethodInfo>();
        HashSet<MethodInfo> calledTargets = new HashSet<MethodInfo>();
        for (MethodInfo target : targets) {
            if (this.callGraph.callersFor(target).isEmpty()) continue;
            calledTargets.add(target);
        }
        if (calledTargets.isEmpty()) {
            return Collections.emptySet();
        }
        ReachabilityIterator iterator = ReachabilityIterator.forVertices(this.callGraph.getGraph(), calledTargets);
        while (iterator.hasNext()) {
            MethodInfo method = (MethodInfo)iterator.next();
            if (!entry.contains(method)) continue;
            result.add(method);
        }
        return result;
    }

    public static class ReachabilityIterator
    extends CrossComponentIterator<MethodInfo, CallSite, Void> {
        private final Deque<MethodInfo> queue;

        public static ReachabilityIterator forVertices(DirectedPseudograph<MethodInfo, CallSite> graph, Set<MethodInfo> startVertices) {
            if (startVertices.isEmpty()) {
                throw new IllegalArgumentException("non-empty starting set required");
            }
            for (MethodInfo vertex : startVertices) {
                if (graph.containsVertex((Object)vertex)) continue;
                throw new IllegalArgumentException("graph does not contain vertex " + vertex);
            }
            ArrayDeque<MethodInfo> queue = new ArrayDeque<MethodInfo>(startVertices);
            MethodInfo start = startVertices.iterator().next();
            queue.remove(start);
            return new ReachabilityIterator((Graph<MethodInfo, CallSite>)new EdgeReversedGraph(graph), start, queue);
        }

        private ReachabilityIterator(Graph<MethodInfo, CallSite> graph, MethodInfo startVertex, Deque<MethodInfo> queue) {
            super(graph, (Object)startVertex);
            this.queue = queue;
        }

        protected boolean isConnectedComponentExhausted() {
            return this.queue.isEmpty();
        }

        protected void encounterVertex(MethodInfo vertex, CallSite edge) {
            this.putSeenData(vertex, null);
            this.queue.add(vertex);
        }

        protected MethodInfo provideNextVertex() {
            return this.queue.removeFirst();
        }

        protected void encounterVertexAgain(MethodInfo vertex, CallSite edge) {
        }
    }
}

