/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.methods;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sourceclear.analysis.latte.genids.Id;
import com.sourceclear.methods.MethodInfo;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Optional;

public class JSMethodInfo
implements MethodInfo {
    @JsonProperty
    private final Id id;
    @JsonProperty
    private final String module;

    public static Optional<JSMethodInfo> parse(String id) {
        return Id.Companion.parse(id).map(JSMethodInfo::new);
    }

    public static Optional<JSMethodInfo> parse(String module, String file, String idComponents) {
        return Id.Companion.parseIdComponents(file, idComponents).map(id -> new JSMethodInfo(module, (Id)id));
    }

    public JSMethodInfo(Id id) {
        this.id = id;
        this.module = null;
    }

    @JsonCreator
    public JSMethodInfo(@JsonProperty(value="module") String module, @JsonProperty(value="id") Id id) {
        this.id = id;
        this.module = module;
    }

    @Override
    @JsonIgnore
    public String getModuleName() {
        return this.module;
    }

    @Override
    @JsonIgnore
    public String getClassName() {
        return this.id.getFilename();
    }

    @Override
    @JsonIgnore
    public String getMethodName() {
        return this.id.idComponentsToString();
    }

    @Override
    @JsonIgnore
    public String getDesc() {
        return null;
    }

    public String toString() {
        return (this.module == null ? "" : this.module + "!") + this.id.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSMethodInfo that = (JSMethodInfo)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.module, that.module);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    @JsonIgnore
    public Path getPath() {
        if (this.module == null) {
            return Paths.get(this.id.getFilename(), new String[0]);
        }
        return Paths.get("node_modules", this.module, this.id.getFilename()).toAbsolutePath();
    }

    public Id getId() {
        return this.id;
    }
}

