/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.publicmethods.java;

import com.sourceclear.analysis.utils.Utils;
import com.sourceclear.methods.MethodDefinition;
import com.sourceclear.methods.MethodInfo;
import com.sourceclear.methods.MethodInfoImpl;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class JavaVisitor
extends ClassVisitor {
    private String currentClass = "";
    private final List<MethodInfo> result = new ArrayList<MethodInfo>();
    private final boolean publicOnly;

    public JavaVisitor() {
        this(true);
    }

    public JavaVisitor(boolean publicOnly) {
        super(458752);
        this.publicOnly = publicOnly;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.currentClass = name;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        EnumSet<MethodDefinition.Attribute> attributes = Utils.attributesFromAccess(access);
        boolean isSynthetic = attributes.contains((Object)MethodDefinition.Attribute.SYNTHETIC);
        if (isSynthetic) {
            return null;
        }
        boolean isPublic = Utils.is(access, 1);
        if (this.publicOnly && !isPublic) {
            return null;
        }
        this.result.add(new MethodInfoImpl(this.currentClass, name, Utils.stripReturnType(desc)));
        return null;
    }

    public List<MethodInfo> getResult() {
        return new ArrayList<MethodInfo>(this.result);
    }
}

