/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.util.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.sourceclear.util.config.DockerfileScanReport;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.BaseStream;

abstract class DockerfileScanReport_Builder {
    private String filepath;
    private final DockerfileScanIssueBuilderList issues = new DockerfileScanIssueBuilderList();
    private final EnumSet<Property> _unsetProperties = EnumSet.allOf(Property.class);

    DockerfileScanReport_Builder() {
    }

    public static DockerfileScanReport.Builder from(DockerfileScanReport value) {
        if (value instanceof Rebuildable) {
            return ((Rebuildable)value).toBuilder();
        }
        return new DockerfileScanReport.Builder().mergeFrom(value);
    }

    @JsonProperty(value="filepath")
    public DockerfileScanReport.Builder filepath(String filepath) {
        this.filepath = Objects.requireNonNull(filepath);
        this._unsetProperties.remove((Object)Property.FILEPATH);
        return (DockerfileScanReport.Builder)this;
    }

    public DockerfileScanReport.Builder mapFilepath(UnaryOperator<String> mapper) {
        Objects.requireNonNull(mapper);
        return this.filepath((String)mapper.apply(this.filepath()));
    }

    public String filepath() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.FILEPATH) ? 1 : 0) != 0, (Object)"filepath not set");
        return this.filepath;
    }

    public DockerfileScanReport.Builder addIssues(DockerfileScanReport.DockerfileScanIssue element) {
        this.issues.addValue(element);
        return (DockerfileScanReport.Builder)this;
    }

    public DockerfileScanReport.Builder addIssues(DockerfileScanReport.DockerfileScanIssue.Builder builder) {
        this.issues.add(new DockerfileScanReport.DockerfileScanIssue.Builder().mergeFrom(builder));
        return (DockerfileScanReport.Builder)this;
    }

    public DockerfileScanReport.Builder addIssues(DockerfileScanReport.DockerfileScanIssue ... elements) {
        return this.addAllIssues(Arrays.asList(elements));
    }

    public DockerfileScanReport.Builder addIssues(DockerfileScanReport.DockerfileScanIssue.Builder ... elementBuilders) {
        return this.addAllBuildersOfIssues(Arrays.asList(elementBuilders));
    }

    public DockerfileScanReport.Builder addAllIssues(Spliterator<? extends DockerfileScanReport.DockerfileScanIssue> elements) {
        long newSize;
        if ((elements.characteristics() & 0x40) != 0 && (newSize = elements.estimateSize() + (long)this.issues.size()) <= Integer.MAX_VALUE) {
            this.issues.ensureCapacity((int)newSize);
        }
        elements.forEachRemaining(this::addIssues);
        return (DockerfileScanReport.Builder)this;
    }

    public DockerfileScanReport.Builder addAllBuildersOfIssues(Spliterator<? extends DockerfileScanReport.DockerfileScanIssue.Builder> elementBuilders) {
        long newSize;
        if ((elementBuilders.characteristics() & 0x40) != 0 && (newSize = elementBuilders.estimateSize() + (long)this.issues.size()) <= Integer.MAX_VALUE) {
            this.issues.ensureCapacity((int)newSize);
        }
        elementBuilders.forEachRemaining(this::addIssues);
        return (DockerfileScanReport.Builder)this;
    }

    @JsonProperty(value="issues")
    public DockerfileScanReport.Builder addAllIssues(Iterable<? extends DockerfileScanReport.DockerfileScanIssue> elements) {
        this.issues.addAllValues(elements);
        return (DockerfileScanReport.Builder)this;
    }

    public DockerfileScanReport.Builder addAllBuildersOfIssues(Iterable<? extends DockerfileScanReport.DockerfileScanIssue.Builder> elementBuilders) {
        return this.addAllBuildersOfIssues(elementBuilders.spliterator());
    }

    public DockerfileScanReport.Builder addAllIssues(BaseStream<? extends DockerfileScanReport.DockerfileScanIssue, ?> elements) {
        return this.addAllIssues(elements.spliterator());
    }

    public DockerfileScanReport.Builder addAllBuildersOfIssues(BaseStream<? extends DockerfileScanReport.DockerfileScanIssue.Builder, ?> elementBuilders) {
        return this.addAllBuildersOfIssues(elementBuilders.spliterator());
    }

    public DockerfileScanReport.Builder mutateIssues(Consumer<? super List<DockerfileScanReport.DockerfileScanIssue.Builder>> mutator) {
        mutator.accept(this.issues);
        return (DockerfileScanReport.Builder)this;
    }

    public DockerfileScanReport.Builder clearIssues() {
        this.issues.clear();
        return (DockerfileScanReport.Builder)this;
    }

    public List<DockerfileScanReport.DockerfileScanIssue.Builder> buildersOfIssues() {
        return Collections.unmodifiableList(this.issues);
    }

    public DockerfileScanReport.Builder mergeFrom(DockerfileScanReport value) {
        DockerfileScanReport.Builder defaults = new DockerfileScanReport.Builder();
        if (defaults._unsetProperties.contains((Object)Property.FILEPATH) || !Objects.equals(value.filepath(), ((DockerfileScanReport_Builder)defaults).filepath())) {
            this.filepath(value.filepath());
        }
        this.addAllIssues(value.issues());
        return (DockerfileScanReport.Builder)this;
    }

    public DockerfileScanReport.Builder mergeFrom(DockerfileScanReport.Builder template) {
        DockerfileScanReport.Builder base = template;
        DockerfileScanReport.Builder defaults = new DockerfileScanReport.Builder();
        if (!(base._unsetProperties.contains((Object)Property.FILEPATH) || !defaults._unsetProperties.contains((Object)Property.FILEPATH) && Objects.equals(template.filepath(), ((DockerfileScanReport_Builder)defaults).filepath()))) {
            this.filepath(template.filepath());
        }
        this.addAllBuildersOfIssues(base.issues);
        return (DockerfileScanReport.Builder)this;
    }

    public DockerfileScanReport.Builder clear() {
        DockerfileScanReport.Builder defaults = new DockerfileScanReport.Builder();
        this.filepath = defaults.filepath;
        this.clearIssues();
        this._unsetProperties.clear();
        this._unsetProperties.addAll(defaults._unsetProperties);
        return (DockerfileScanReport.Builder)this;
    }

    public DockerfileScanReport build() {
        Preconditions.checkState((boolean)this._unsetProperties.isEmpty(), (String)"Not set: %s", this._unsetProperties);
        return new Value(this);
    }

    @VisibleForTesting
    public DockerfileScanReport buildPartial() {
        return new Partial(this);
    }

    private class DockerfileScanIssueBuilderList
    extends AbstractList<DockerfileScanReport.DockerfileScanIssue.Builder>
    implements RandomAccess {
        private List elements = ImmutableList.of();

        private DockerfileScanIssueBuilderList() {
        }

        @Override
        public int size() {
            return this.elements.size();
        }

        @Override
        public DockerfileScanReport.DockerfileScanIssue.Builder get(int index) {
            Object element = this.elements.get(index);
            if (element instanceof DockerfileScanReport.DockerfileScanIssue) {
                if (this.elements instanceof ImmutableList) {
                    this.elements = new ArrayList(this.elements);
                }
                element = new DockerfileScanReport.DockerfileScanIssue.Builder().mergeFrom((DockerfileScanReport.DockerfileScanIssue)element);
                this.elements.set(index, element);
            }
            return (DockerfileScanReport.DockerfileScanIssue.Builder)element;
        }

        @Override
        public DockerfileScanReport.DockerfileScanIssue.Builder set(int index, DockerfileScanReport.DockerfileScanIssue.Builder element) {
            DockerfileScanReport.DockerfileScanIssue.Builder oldElement;
            if (this.elements instanceof ImmutableList) {
                this.elements = new ArrayList(this.elements);
            }
            if ((oldElement = this.elements.set(index, element)) instanceof DockerfileScanReport.DockerfileScanIssue) {
                oldElement = new DockerfileScanReport.DockerfileScanIssue.Builder().mergeFrom((DockerfileScanReport.DockerfileScanIssue)((Object)oldElement));
            }
            return oldElement;
        }

        @Override
        public void add(int index, DockerfileScanReport.DockerfileScanIssue.Builder element) {
            if (this.elements instanceof ImmutableList) {
                this.elements = new ArrayList(this.elements);
            }
            this.elements.add(index, element);
        }

        @Override
        public DockerfileScanReport.DockerfileScanIssue.Builder remove(int index) {
            Object oldElement;
            if (this.elements instanceof ImmutableList) {
                this.elements = new ArrayList(this.elements);
            }
            if ((oldElement = this.elements.remove(index)) instanceof DockerfileScanReport.DockerfileScanIssue) {
                oldElement = new DockerfileScanReport.DockerfileScanIssue.Builder().mergeFrom((DockerfileScanReport.DockerfileScanIssue)oldElement);
            }
            return (DockerfileScanReport.DockerfileScanIssue.Builder)oldElement;
        }

        void ensureCapacity(int minCapacity) {
            if (this.elements instanceof ImmutableList) {
                this.elements = new ArrayList(this.elements);
            }
            ((ArrayList)this.elements).ensureCapacity(minCapacity);
        }

        void addValue(DockerfileScanReport.DockerfileScanIssue element) {
            Objects.requireNonNull(element);
            if (this.elements instanceof ImmutableList) {
                this.elements = new ArrayList(this.elements);
            }
            this.elements.add(element);
        }

        void addAllValues(Iterable<? extends DockerfileScanReport.DockerfileScanIssue> values) {
            if (this.elements.isEmpty() && values instanceof ImmutableList) {
                this.elements = (ImmutableList)values;
            } else {
                if (this.elements instanceof ImmutableList) {
                    this.elements = new ArrayList(this.elements);
                }
                if (values instanceof Collection) {
                    int newSize = this.elements.size() + ((Collection)values).size();
                    ((ArrayList)this.elements).ensureCapacity(newSize);
                }
                values.forEach(this::addValue);
            }
        }

        ImmutableList<DockerfileScanReport.DockerfileScanIssue> build() {
            if (this.elements instanceof ImmutableList) {
                return (ImmutableList)this.elements;
            }
            ImmutableList.Builder values = ImmutableList.builder();
            for (Object element : this.elements) {
                values.add((Object)this.build(element));
            }
            return values.build();
        }

        private DockerfileScanReport.DockerfileScanIssue build(Object element) {
            if (element instanceof DockerfileScanReport.DockerfileScanIssue) {
                return (DockerfileScanReport.DockerfileScanIssue)element;
            }
            return ((DockerfileScanReport.DockerfileScanIssue.Builder)element).build();
        }

        ImmutableList<DockerfileScanReport.DockerfileScanIssue> buildPartial() {
            if (this.elements instanceof ImmutableList) {
                return (ImmutableList)this.elements;
            }
            ImmutableList.Builder values = ImmutableList.builder();
            for (Object element : this.elements) {
                values.add((Object)this.buildPartial(element));
            }
            return values.build();
        }

        private DockerfileScanReport.DockerfileScanIssue buildPartial(Object element) {
            if (element instanceof DockerfileScanReport.DockerfileScanIssue) {
                return (DockerfileScanReport.DockerfileScanIssue)element;
            }
            return ((DockerfileScanReport.DockerfileScanIssue.Builder)element).buildPartial();
        }
    }

    private static final class Partial
    extends Rebuildable {
        private final String filepath;
        private final ImmutableList<DockerfileScanReport.DockerfileScanIssue> issues;
        private final EnumSet<Property> _unsetProperties;

        Partial(DockerfileScanReport_Builder builder) {
            this.filepath = builder.filepath;
            this.issues = builder.issues.buildPartial();
            this._unsetProperties = builder._unsetProperties.clone();
        }

        @Override
        @JsonProperty(value="filepath")
        public String filepath() {
            if (this._unsetProperties.contains((Object)Property.FILEPATH)) {
                throw new UnsupportedOperationException("filepath not set");
            }
            return this.filepath;
        }

        @Override
        @JsonProperty(value="issues")
        public List<DockerfileScanReport.DockerfileScanIssue> issues() {
            return this.issues;
        }

        @Override
        public DockerfileScanReport.Builder toBuilder() {
            PartialBuilder builder = new PartialBuilder();
            ((DockerfileScanReport_Builder)builder).filepath = this.filepath;
            ((DockerfileScanReport_Builder)builder).addAllIssues((Iterable<? extends DockerfileScanReport.DockerfileScanIssue>)this.issues);
            ((DockerfileScanReport_Builder)builder)._unsetProperties.clear();
            ((DockerfileScanReport_Builder)builder)._unsetProperties.addAll(this._unsetProperties);
            return builder;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)obj;
            return Objects.equals(this.filepath, other.filepath) && Objects.equals(this.issues, other.issues) && Objects.equals(this._unsetProperties, other._unsetProperties);
        }

        public int hashCode() {
            return Objects.hash(this.filepath, this.issues, this._unsetProperties);
        }

        public String toString() {
            StringBuilder result = new StringBuilder("partial DockerfileScanReport{");
            if (!this._unsetProperties.contains((Object)Property.FILEPATH)) {
                result.append("filepath=").append(this.filepath).append(", ");
            }
            return result.append("issues=").append(this.issues).append("}").toString();
        }

        private static class PartialBuilder
        extends DockerfileScanReport.Builder {
            private PartialBuilder() {
            }

            @Override
            public DockerfileScanReport build() {
                return this.buildPartial();
            }
        }
    }

    private static final class Value
    extends Rebuildable {
        private final String filepath;
        private final ImmutableList<DockerfileScanReport.DockerfileScanIssue> issues;

        private Value(DockerfileScanReport_Builder builder) {
            this.filepath = builder.filepath;
            this.issues = builder.issues.build();
        }

        @Override
        @JsonProperty(value="filepath")
        public String filepath() {
            return this.filepath;
        }

        @Override
        @JsonProperty(value="issues")
        public List<DockerfileScanReport.DockerfileScanIssue> issues() {
            return this.issues;
        }

        @Override
        public DockerfileScanReport.Builder toBuilder() {
            DockerfileScanReport.Builder builder = new DockerfileScanReport.Builder();
            ((DockerfileScanReport_Builder)builder).filepath = this.filepath;
            ((DockerfileScanReport_Builder)builder).addAllIssues((Iterable<? extends DockerfileScanReport.DockerfileScanIssue>)this.issues);
            ((DockerfileScanReport_Builder)builder)._unsetProperties.clear();
            return builder;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            return Objects.equals(this.filepath, other.filepath) && Objects.equals(this.issues, other.issues);
        }

        public int hashCode() {
            return Objects.hash(this.filepath, this.issues);
        }

        public String toString() {
            return "DockerfileScanReport{filepath=" + this.filepath + ", issues=" + this.issues + "}";
        }
    }

    private static abstract class Rebuildable
    implements DockerfileScanReport {
        private Rebuildable() {
        }

        public abstract DockerfileScanReport.Builder toBuilder();
    }

    private static enum Property {
        FILEPATH("filepath");

        private final String name;

        private Property(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

