/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.util.fingerprints;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.sourceclear.util.fingerprints.VersionResolver;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ManifestVersionResolver {
    private static final ImmutableList<String> VERSION_ATTRIBUTES = ImmutableList.of((Object)"Implementation-Version", (Object)"Bundle-Version");
    private static final VersionResolver VERSION_RESOLVER = VersionResolver.getInstance();

    public List<String> readManifest(InputStream input) throws IOException {
        List<String> entries = new ArrayList<String>();
        JarInputStream jarStream = new JarInputStream(input);
        Manifest mf = jarStream.getManifest();
        if (mf == null) {
            return entries;
        }
        entries = this.versionSearch(mf.getMainAttributes());
        for (Attributes attrs : mf.getEntries().values()) {
            entries.addAll(this.versionSearch(attrs));
        }
        return entries;
    }

    public String resolve(List<String> entries) {
        if (!entries.isEmpty()) {
            return VERSION_RESOLVER.resolve(entries.get(0)).getVersionString();
        }
        return null;
    }

    public String resolve(InputStream input) throws IOException {
        return this.resolve(this.readManifest(input));
    }

    private List<String> versionSearch(Attributes attributes) {
        ArrayList versions = Lists.newArrayList();
        for (String attribute : VERSION_ATTRIBUTES) {
            String v = attributes.getValue(attribute);
            if (v == null) continue;
            versions.add(v);
        }
        return versions;
    }
}

