/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.util.io;

import com.veracode.security.logging.SecureLogger;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class GitUrlUtils {
    private static final SecureLogger LOGGER = SecureLogger.getLogger(GitUrlUtils.class);
    private static final Pattern GITHUB = Pattern.compile("https://github\\.com/.+");
    private static final Pattern BITBUCKET = Pattern.compile("https://bitbucket\\.org|com/.+");

    public static Optional<String> bestGitCloneUrl(String ... urls) {
        List shortedListed = Stream.of(urls).filter(StringUtils::isNotBlank).map(url -> GitUrlUtils.cleanUrl(url).orElse(null)).filter(Objects::nonNull).collect(Collectors.toList());
        if (shortedListed.isEmpty()) {
            return Optional.empty();
        }
        String bestMatch = shortedListed.stream().filter(s -> GITHUB.matcher((CharSequence)s).find() || BITBUCKET.matcher((CharSequence)s).find()).findFirst().orElse((String)shortedListed.get(0));
        return Optional.of(StringUtils.removeEnd((String)bestMatch, (String)".git"));
    }

    private static Optional<String> cleanUrl(String url) {
        String host;
        Optional<URI> uriOptional;
        String derived = GitUrlUtils.deriveScmUrlFromCodeRepoUrl(url);
        if (derived.contains("github.com:")) {
            derived = derived.replaceFirst("github.com:", "github.com/");
        }
        if (!(uriOptional = GitUrlUtils.parseUri(derived)).isPresent()) {
            return Optional.empty();
        }
        if (!(uriOptional = GitUrlUtils.handleUriPathIsWholeString(uriOptional.get(), derived)).isPresent()) {
            return Optional.empty();
        }
        URI uri = uriOptional.get();
        if (uri.getScheme() != null && uri.getScheme().contains("svn")) {
            return Optional.empty();
        }
        String string = host = uri.getHost() == null ? null : uri.getHost().toLowerCase();
        if (host == null || host.contains("svn.") || host.contains(".svn")) {
            return Optional.empty();
        }
        Optional<String> authority = GitUrlUtils.cleanGitAt(uri.getAuthority());
        if (!authority.isPresent()) {
            return Optional.empty();
        }
        Optional<String> path = GitUrlUtils.cleanUpRepoPaths(host, uri.getPath());
        return path.map(s -> "https://" + (String)authority.get() + s);
    }

    private static Optional<String> cleanGitAt(String s) {
        if (s.startsWith("git@")) {
            return Optional.of(s.replaceFirst("git@", ""));
        }
        if (s.startsWith("hg@")) {
            return Optional.empty();
        }
        return Optional.of(s);
    }

    private static Optional<URI> parseUri(String s) {
        try {
            return Optional.of(URI.create(s));
        }
        catch (Exception ex) {
            return Optional.empty();
        }
    }

    private static Optional<URI> handleUriPathIsWholeString(URI uri, String s) {
        if (uri.getPath() == null) {
            return Optional.empty();
        }
        if (uri.getPath().equals(s)) {
            if ((s = (String)GitUrlUtils.cleanGitAt(s).map(cleaned -> "https://" + cleaned).orElse(null)) != null) {
                return GitUrlUtils.parseUri(s);
            }
            return Optional.empty();
        }
        return Optional.of(uri);
    }

    private static Optional<String> cleanUpRepoPaths(String host, String uriPath) {
        if (host.equals("github.com") || host.equals("bitbucket.org") || host.equals("bitbucket.com")) {
            String[] pathSegments = (uriPath = uriPath.startsWith("/") ? uriPath.substring(1) : uriPath).split("/");
            if (pathSegments.length < 2) {
                return Optional.empty();
            }
            return Optional.of(String.format("/%s/%s", pathSegments[0], pathSegments[1]));
        }
        return Optional.ofNullable(uriPath);
    }

    private static String deriveScmUrlFromCodeRepoUrl(String codeRepoUrl) {
        int numOfColons = StringUtils.countMatches((CharSequence)(codeRepoUrl = codeRepoUrl.trim().toLowerCase()), (CharSequence)":");
        if (numOfColons > 1) {
            int secondLastColon = StringUtils.lastOrdinalIndexOf((CharSequence)codeRepoUrl, (CharSequence)":", (int)2);
            codeRepoUrl = codeRepoUrl.substring(secondLastColon + 1);
        }
        if (codeRepoUrl.startsWith("git+http://") || codeRepoUrl.startsWith("http+git://")) {
            return String.format("http:%s", URI.create(codeRepoUrl).getSchemeSpecificPart());
        }
        if (codeRepoUrl.startsWith("git+https://") || codeRepoUrl.startsWith("https+git://")) {
            return String.format("https:%s", URI.create(codeRepoUrl).getSchemeSpecificPart());
        }
        return codeRepoUrl;
    }
}

