/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.util.io;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteStreams;
import com.sourceclear.util.io.ExecutableResolver;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class SrcclrIo {
    private static final ExecutorService EXECUTORS;
    private static ExecutableResolver EXECUTABLE_RESOLVER;

    public static Future<String> readAsync(InputStream is) {
        return EXECUTORS.submit(() -> {
            String str = new String(ByteStreams.toByteArray((InputStream)is), Charsets.UTF_8);
            is.close();
            return str;
        });
    }

    public static String resolveExecutable(String name) {
        return EXECUTABLE_RESOLVER.resolve(name);
    }

    public static Optional<String> resolveExecutableIn(String name, List<Path> paths) {
        String maybeExe = new ExecutableResolver(() -> paths.stream().map(Path::toString).collect(Collectors.toList())).resolve(name);
        return Optional.ofNullable(maybeExe);
    }

    public static ImmutableMap<String, String> resolveExecutables(Collection<String> names) {
        return ImmutableMap.copyOf(EXECUTABLE_RESOLVER.resolve(names));
    }

    static {
        EXECUTABLE_RESOLVER = new ExecutableResolver();
        EXECUTORS = Executors.newCachedThreadPool(new ThreadFactory(){
            private final AtomicInteger count = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("IO Thread " + this.count.addAndGet(1));
                t.setDaemon(true);
                return t;
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                EXECUTORS.shutdownNow();
            }
        });
    }
}

