/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.bytecode;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import com.sourceclear.bytecode.ByteArrayInputStreamGenerator;
import com.sourceclear.bytecode.HashedMethodFingerprint;
import com.sourceclear.bytecode.InputStreamGenerator;
import com.sourceclear.bytecode.JarInputStreamGenerator;
import com.sourceclear.bytecode.MethodDiffInfo;
import com.sourceclear.bytecode.MethodFingerprint;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;

public class Util {
    public static final Set<String> JAR_EXTENSIONS = Sets.newHashSet((Object[])new String[]{".jar", ".ear", ".war"});
    public static final Set<String> AAR_EXTENSIONS = Sets.newHashSet((Object[])new String[]{".aar"});
    public static final String APK_CLASS_EXTENSION = ".dex";
    public static final Set<String> APK_VERSION_FILE_EXTENSION = Sets.newHashSet((Object[])new String[]{".version"});
    public static final Set<String> PROPERTIES_FILE_EXTENSION = Sets.newHashSet((Object[])new String[]{".properties"});
    public static final String CLASS_EXTENSION = ".class";

    static boolean hasExtension(String fileName, Set<String> extensions) {
        String lowerCaseFileName = fileName.toLowerCase();
        for (String ext : extensions) {
            if (!lowerCaseFileName.endsWith(ext.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasJarExtension(File file) {
        return Util.hasExtension(file.getName(), JAR_EXTENSIONS);
    }

    public static boolean hasAarExtension(File file) {
        return Util.hasExtension(file.getName(), AAR_EXTENSIONS);
    }

    public static boolean hasApkVersionExtension(File file) {
        return Util.hasExtension(file.getName(), APK_VERSION_FILE_EXTENSION);
    }

    public static boolean hasPropertiesExtension(File file) {
        return Util.hasExtension(file.getName(), PROPERTIES_FILE_EXTENSION);
    }

    public static byte[] hashInts(Collection<Integer> collection) {
        MessageDigest digest = DigestUtils.getSha256Digest();
        for (Integer i : collection) {
            digest.update(Ints.toByteArray((int)i));
        }
        return digest.digest();
    }

    public static byte[] hashBytes(Collection<byte[]> collection) {
        MessageDigest digest = DigestUtils.getSha256Digest();
        for (byte[] b : collection) {
            digest.update(b);
        }
        return digest.digest();
    }

    public static final <T> ImmutableList<T> addedItems(ImmutableCollection<T> source, ImmutableCollection<T> dest) {
        ImmutableList.Builder LL = new ImmutableList.Builder();
        for (Object item : dest) {
            if (source.contains(item)) continue;
            LL.add(item);
        }
        return LL.build();
    }

    public static final ImmutableSet<Integer> immutableSetStringtoInt(ImmutableSet<String> stringSet) {
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        for (String s : stringSet) {
            builder.add((Object)s.hashCode());
        }
        return builder.build();
    }

    public static final ImmutableSet<String> immutableSetInttoString(ImmutableSet<Integer> integerSet) {
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        for (Integer i : integerSet) {
            builder.add((Object)i.toString());
        }
        return builder.build();
    }

    public static final ImmutableList<String> immutableListInttoString(ImmutableList<Integer> integerList) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (Integer i : integerList) {
            builder.add((Object)i.toString());
        }
        return builder.build();
    }

    public static final ImmutableList<Integer> immutableListStringtoInt(ImmutableList<String> stringList) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (String s : stringList) {
            builder.add((Object)s.hashCode());
        }
        return builder.build();
    }

    public static final ImmutableMap<String, MethodFingerprint> immutableMapInttoString(ImmutableMap<Integer, HashedMethodFingerprint> methodsMap) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (Integer i : methodsMap.keySet()) {
            MethodFingerprint mfp = new MethodFingerprint(((HashedMethodFingerprint)methodsMap.get((Object)i)).getOpCodes());
            builder.put((Object)i.toString(), (Object)mfp);
        }
        return builder.build();
    }

    public static final ImmutableMap<Integer, MethodFingerprint> immutableMapStringtoInt(ImmutableMap<String, MethodFingerprint> methodsMap) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        LinkedList<Integer> hashCodes = new LinkedList<Integer>();
        for (String s : methodsMap.keySet()) {
            int hc = s.hashCode();
            if (hashCodes.contains(hc)) continue;
            builder.put((Object)hc, (Object)((MethodFingerprint)methodsMap.get((Object)s)));
            hashCodes.add(hc);
        }
        try {
            return builder.build();
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static final ImmutableMap<String, MethodFingerprint> immutableMapConstruct(Map<String, List<Integer>> methodsMap) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (String s : methodsMap.keySet()) {
            builder.put((Object)s, (Object)new MethodFingerprint((ImmutableList<Integer>)ImmutableList.copyOf((Collection)methodsMap.get(s))));
        }
        return builder.build();
    }

    public static ImmutableMap<String, MethodDiffInfo> changedMethods(ImmutableMap<String, MethodFingerprint> source, ImmutableMap<String, MethodFingerprint> dest) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (String s : source.keySet()) {
            MethodDiffInfo mdi;
            if (!dest.containsKey((Object)s) || (mdi = ((MethodFingerprint)source.get((Object)s)).diffMethod((MethodFingerprint)dest.get((Object)s))).getInsnAdded().isEmpty() && mdi.getInsnRemoved().isEmpty()) continue;
            builder.put((Object)s, (Object)mdi);
        }
        return builder.build();
    }

    public static ImmutableSortedMap<Integer, HashedMethodFingerprint> immutableMapStringtoimmmutableSortedMapInt(ImmutableMap<String, MethodFingerprint> methodsMap) {
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        LinkedList<Integer> hashCodes = new LinkedList<Integer>();
        for (String s : methodsMap.keySet()) {
            int hc = s.hashCode();
            if (hashCodes.contains(hc)) continue;
            HashedMethodFingerprint hmfp = new HashedMethodFingerprint((MethodFingerprint)methodsMap.get((Object)s));
            builder.put((Object)hc, (Object)hmfp);
            hashCodes.add(hc);
        }
        try {
            return builder.build();
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static ImmutableSortedSet<Integer> immutableSetStringtoImmutableSortedSetInt(ImmutableSet<String> stringSet) {
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.naturalOrder();
        for (String s : stringSet) {
            builder.add((Object)s.hashCode());
        }
        return builder.build();
    }

    public static Map<String, InputStreamGenerator> readEntries(JarInputStream jis) throws IOException {
        JarEntry jarEntry;
        HashMap map = Maps.newHashMap();
        while ((jarEntry = jis.getNextJarEntry()) != null) {
            if (jarEntry.isDirectory()) {
                jis.closeEntry();
                continue;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)jis, (OutputStream)baos);
            jis.closeEntry();
            ByteArrayInputStreamGenerator baisGenerator = new ByteArrayInputStreamGenerator(baos.toByteArray());
            String jarName = jarEntry.getName();
            if (Util.hasExtension(jarName, JAR_EXTENSIONS) || Util.hasExtension(jarName, AAR_EXTENSIONS)) {
                map.put(jarName, new JarInputStreamGenerator(baisGenerator));
                continue;
            }
            if (!Util.hasExtension(jarName, Collections.singleton(CLASS_EXTENSION))) continue;
            map.put(jarName, baisGenerator);
        }
        return map;
    }
}

