/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.methods;

import com.sourceclear.analysis.latte.frameworks.Frameworks;
import com.sourceclear.analysis.latte.genids.Id;
import com.sourceclear.api.data.methods.MethodCallData;
import com.sourceclear.api.data.methods.MethodModel;
import com.sourceclear.engine.common.logging.LogStream;
import com.sourceclear.engine.methods.BaseMethodsEngine;
import com.sourceclear.engine.methods.InstanceFrameworkMethod;
import com.sourceclear.engine.methods.MethodScanBatcher;
import com.sourceclear.engine.methods.MethodsEngine;
import com.sourceclear.engine.methods.SimpleDirectoryMethodScanBatcher;
import com.sourceclear.methods.CallSite;
import com.sourceclear.methods.JSMethodInfo;
import com.sourceclear.methods.MethodInfo;
import com.sourceclear.methods.MethodScannerFactory;
import com.sourceclear.methods.VulnMethodsConfig;
import com.sourceclear.methods.js.JSMethodScannerFactory;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;

@Immutable
public class JSMethodsEngine
extends BaseMethodsEngine {
    private static final String MALFORMED_MESSAGE = "The method model must correspond to an JavaScript MethodModel";
    private final MethodScannerFactory methodScannerFactory = new JSMethodScannerFactory();
    private Set<CallSite> dynamicEdges = Collections.emptySet();
    private Set<MethodInfo> stubbedPublicMethods = Collections.emptySet();
    private final Set<Frameworks.Module> stubbedFrameworkMethods = new HashSet<Frameworks.Module>();

    @Override
    public MethodsEngine.Result scanMethods(Path scanRoot, Collection<MethodCallData> inputMethodData, LogStream logStream) {
        try {
            return this.innerScanMethods(scanRoot, inputMethodData, logStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public MethodsEngine withDynamicEdges(Set<CallSite> edges) {
        this.dynamicEdges = edges;
        return this;
    }

    @Override
    public MethodsEngine withFrameworkMethodStubs(Collection<InstanceFrameworkMethod> frameworkMethods) {
        frameworkMethods.forEach(instanceMethod -> {
            Set<Frameworks.Function> funcs = instanceMethod.frameworkMethods().stream().map(frameworkMethod -> {
                int argCount = frameworkMethod.getArgCount() != null ? frameworkMethod.getArgCount() : 0;
                Set<Frameworks.Argument> args = frameworkMethod.getCalls().stream().map(index -> new Frameworks.Argument(argCount, (int)index)).collect(Collectors.toSet());
                return new Frameworks.Function(this.toMethodInfo(frameworkMethod.getMethod(), false).getId(), args);
            }).collect(Collectors.toSet());
            if (!funcs.isEmpty()) {
                this.stubbedFrameworkMethods.add(new Frameworks.Module(instanceMethod.frameworkMethods().iterator().next().getMethod().getModuleName(), funcs));
            }
        });
        return this;
    }

    @Override
    public MethodsEngine withPublicMethodStubs(Collection<MethodInfo> publicMethodStubs) {
        this.stubbedPublicMethods = new HashSet<MethodInfo>(publicMethodStubs);
        return this;
    }

    @Override
    public MethodsEngine withVulnMethodsConfig(VulnMethodsConfig config) {
        this.methodScannerFactory.withVulnMethodsConfig(config);
        return this;
    }

    @Override
    public VulnMethodsConfig.Builder defaultConfig() {
        return this.methodScannerFactory.defaultVulnMethodsConfig().parallel(true);
    }

    @Override
    MethodScanBatcher setupBatcher(Path scanRoot, LogStream logStream) {
        return new SimpleDirectoryMethodScanBatcher(this.methodScannerFactory);
    }

    @Override
    protected void categorizeMethods(MethodCallData methodCallData, Set<MethodInfo> vulnerableMethods, Set<MethodInfo> scanMethods, Set<MethodInfo> malformedMethods) {
        MethodModel vulnerableMethod = methodCallData.getMethod();
        JSMethodInfo vulnerableMethodInfo = this.toMethodInfo(vulnerableMethod, true);
        if (vulnerableMethodInfo.getModuleName() == null) {
            malformedMethods.add(vulnerableMethodInfo);
        } else {
            vulnerableMethods.add(vulnerableMethodInfo);
            scanMethods.addAll(this.getScanMethods(methodCallData));
        }
    }

    @Override
    protected void checkMalformed(Set<MethodInfo> vulnerableMethods, Set<MethodInfo> malformedMethods) {
        for (MethodInfo m : malformedMethods) {
            if (!vulnerableMethods.stream().noneMatch(n -> n.getClassName().equals(m.getClassName()) && n.getMethodName().equals(m.getMethodName()))) continue;
            throw new IllegalArgumentException(MALFORMED_MESSAGE);
        }
    }

    @Override
    public Set<CallSite> getDynamicEdges() {
        return this.dynamicEdges;
    }

    @Override
    public Collection<MethodInfo> getPublicMethodStubs() {
        return this.stubbedPublicMethods;
    }

    @Override
    public Collection<Frameworks.Module> getFrameworkMethodStubs() {
        return this.stubbedFrameworkMethods;
    }

    @Override
    public JSMethodInfo toMethodInfo(MethodModel methodModel, boolean ignoreNoModuleName) {
        if (!ignoreNoModuleName && methodModel.getModuleName() == null || methodModel.getClassName() == null || methodModel.getDescriptor() != null || methodModel.getMethodName() == null) {
            throw new IllegalArgumentException(MALFORMED_MESSAGE);
        }
        String idComponentsStr = methodModel.getMethodName();
        Optional<Id> id = Id.Companion.parseIdComponents(methodModel.getClassName(), idComponentsStr);
        if (!id.isPresent()) {
            throw new IllegalArgumentException(MALFORMED_MESSAGE);
        }
        return new JSMethodInfo(methodModel.getModuleName(), id.get());
    }
}

