/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.methods;

import com.sourceclear.methods.CallGraph;
import com.sourceclear.methods.CallSite;
import com.sourceclear.methods.MethodInfo;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.jgrapht.alg.connectivity.KosarajuStrongConnectivityInspector;
import org.jgrapht.graph.AsSubgraph;
import org.jgrapht.graph.DirectedPseudograph;

public class JGCallGraph
implements CallGraph {
    private final DirectedPseudograph<MethodInfo, CallSite> graph;
    private KosarajuStrongConnectivityInspector<MethodInfo, CallSite> inspector;
    private Map<MethodInfo, Set<MethodInfo>> stronglyConnectedSets;
    private final HashMap<Set<MethodInfo>, AsSubgraph<MethodInfo, CallSite>> stronglyConnectedSubgraphs;

    public JGCallGraph() {
        this((DirectedPseudograph<MethodInfo, CallSite>)new DirectedPseudograph(CallSite.class));
    }

    public JGCallGraph(DirectedPseudograph<MethodInfo, CallSite> graph) {
        this.graph = graph;
        this.inspector = new KosarajuStrongConnectivityInspector(graph);
        this.stronglyConnectedSubgraphs = new HashMap();
    }

    public Set<MethodInfo> allTransitiveCallersFor(MethodInfo method) {
        ArrayDeque<MethodInfo> methods = new ArrayDeque<MethodInfo>();
        methods.add(method);
        HashSet<MethodInfo> result = new HashSet<MethodInfo>();
        while (!methods.isEmpty()) {
            MethodInfo m = (MethodInfo)methods.remove();
            if (result.contains(m)) continue;
            result.add(m);
            for (CallSite callSite : this.callersFor(m)) {
                methods.add(callSite.getCaller());
            }
        }
        return result;
    }

    public void removeEdge(CallSite callSite) {
        this.graph.removeEdge((Object)callSite);
    }

    public AsSubgraph<MethodInfo, CallSite> stronglyConnectedSubgraphOf(CallSite callSite) {
        Set<MethodInfo> stronglyConnectedSet = this.stronglyConnectedSets().get(callSite.getCallee());
        if (stronglyConnectedSet != null && stronglyConnectedSet.contains(callSite.getCaller())) {
            return this.subgraphForVertexSet(stronglyConnectedSet);
        }
        return null;
    }

    private AsSubgraph<MethodInfo, CallSite> subgraphForVertexSet(Set<MethodInfo> vertices) {
        AsSubgraph subgraph = this.stronglyConnectedSubgraphs.get(vertices);
        if (subgraph == null) {
            subgraph = new AsSubgraph(this.graph, vertices, null);
            this.stronglyConnectedSubgraphs.put(vertices, (AsSubgraph<MethodInfo, CallSite>)subgraph);
        }
        return subgraph;
    }

    @Override
    public Set<CallSite> callersFor(MethodInfo callee) {
        Set<CallSite> callers = new HashSet<CallSite>();
        try {
            callers = this.graph.incomingEdgesOf((Object)callee);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return callers;
    }

    @Override
    public boolean containsVertex(MethodInfo vertex) {
        return this.graph.containsVertex((Object)vertex);
    }

    @Override
    public boolean addEdge(CallSite callSite) {
        MethodInfo caller = callSite.getCaller();
        MethodInfo callee = callSite.getCallee();
        this.graph.addVertex((Object)caller);
        this.graph.addVertex((Object)callee);
        return this.graph.addEdge((Object)caller, (Object)callee, (Object)callSite);
    }

    @Override
    public boolean addVertex(MethodInfo method) {
        return this.graph.addVertex((Object)method);
    }

    @Override
    public Stream<MethodInfo> vertices() {
        return this.graph.vertexSet().stream();
    }

    @Override
    public Stream<CallSite> edges() {
        return this.graph.edgeSet().stream();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JGCallGraph callGraph = (JGCallGraph)o;
        if (!this.graph.vertexSet().equals(callGraph.graph.vertexSet())) {
            return false;
        }
        if (!this.graph.edgeSet().equals(callGraph.graph.edgeSet())) {
            return false;
        }
        if (this.stronglyConnectedSets != null ? !this.stronglyConnectedSets.equals(callGraph.stronglyConnectedSets) : callGraph.stronglyConnectedSets != null) {
            return false;
        }
        return this.stronglyConnectedSubgraphs.equals(callGraph.stronglyConnectedSubgraphs);
    }

    public int hashCode() {
        int result = this.graph.hashCode();
        result = 31 * result + (this.stronglyConnectedSets != null ? this.stronglyConnectedSets.hashCode() : 0);
        result = 31 * result + this.stronglyConnectedSubgraphs.hashCode();
        return result;
    }

    private Map<MethodInfo, Set<MethodInfo>> stronglyConnectedSets() {
        if (this.stronglyConnectedSets == null) {
            List sets = this.inspector.stronglyConnectedSets();
            this.stronglyConnectedSets = new HashMap<MethodInfo, Set<MethodInfo>>();
            for (Set stronglyConnectedSet : sets) {
                for (MethodInfo methodInfo : stronglyConnectedSet) {
                    this.stronglyConnectedSets.put(methodInfo, stronglyConnectedSet);
                }
            }
        }
        return this.stronglyConnectedSets;
    }

    public DirectedPseudograph<MethodInfo, CallSite> getGraph() {
        return this.graph;
    }
}

