/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.sgl.lang.predicate;

import com.google.common.collect.ImmutableMap;
import com.sourceclear.sgl.lang.PredicateVisitor;
import com.sourceclear.sgl.lang.predicate.Predicate;
import com.sourceclear.sgl.lang.value.Value;
import java.util.Objects;

public class Relational
implements Predicate {
    private static final ImmutableMap<String, Operator> OPERATOR_OF_STRING = ImmutableMap.of((Object)"<", (Object)((Object)Operator.LESS_THAN), (Object)"<=", (Object)((Object)Operator.LESS_THAN_EQUAL), (Object)">", (Object)((Object)Operator.MORE_THAN), (Object)">=", (Object)((Object)Operator.MORE_THAN_EQUAL));
    private final Operator op;
    private final Value value;

    public Relational(String operator, Value value) {
        Operator op = (Operator)((Object)OPERATOR_OF_STRING.get((Object)operator));
        if (op == null) {
            throw new RuntimeException("Unknown relational operator: " + operator);
        }
        this.op = op;
        this.value = value;
    }

    public Relational(Operator operator, Value value) {
        this.op = operator;
        this.value = value;
    }

    @Override
    public <R> R accept(PredicateVisitor<R> visitor2) {
        return visitor2.visitRelational(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Relational that = (Relational)o;
        return Objects.equals((Object)this.op, (Object)that.op) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.op, this.value});
    }

    public String toString() {
        return String.format("%s %s", new Object[]{this.op, this.value});
    }

    public Value getValue() {
        return this.value;
    }

    public Operator getOp() {
        return this.op;
    }

    public static enum Operator {
        LESS_THAN("<"),
        LESS_THAN_EQUAL("<="),
        MORE_THAN(">"),
        MORE_THAN_EQUAL(">=");

        private final String operator;

        private Operator(String operator) {
            this.operator = operator;
        }

        public String toString() {
            return this.operator;
        }
    }
}

