/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.util.config;

import com.google.common.collect.Iterables;
import com.sourceclear.api.data.artifact.LibraryArtifactApiModel;
import com.sourceclear.api.data.evidence.Evidence;
import com.sourceclear.api.data.evidence.EvidencePath;
import java.util.EnumSet;
import java.util.Optional;

public class Commons {
    public static final float LOW_SEVERITY_THESHOLD = 4.0f;
    public static final float MEDIUM_SEVERITY_THESHOLD = 7.0f;
    public static final float HIGH_SEVERITY_THESHOLD = 9.0f;
    public static final int NON_ERROR_VALUE = 0;

    public static Severity determineSeverity(float cvss) {
        Severity severity = cvss < 4.0f ? Severity.Low : (cvss < 7.0f ? Severity.Medium : (cvss < 9.0f ? Severity.High : Severity.Critical));
        return severity;
    }

    public static Severity determineSeverity(LibraryArtifactApiModel artifact) {
        Optional<Float> srcclrCvss3Score = artifact.getSrcclrCvss3Score();
        Optional<Float> nvdCvss3Score = artifact.getNvdCvss3Score();
        return Commons.determineSeverity(nvdCvss3Score.orElseGet(() -> srcclrCvss3Score.orElse(Float.valueOf(0.0f))).floatValue());
    }

    public static DependencyMode determineDependencyMode(Evidence evidence) {
        EnumSet<DependencyMode> componentDependencyModes = EnumSet.noneOf(DependencyMode.class);
        for (EvidencePath evidencePath : evidence.getEvidencePaths()) {
            DependencyMode dependencyMode = evidencePath.getDependencyPath().isEmpty() ? DependencyMode.DIRECT : DependencyMode.TRANSITIVE;
            componentDependencyModes.add(dependencyMode);
            if (componentDependencyModes.size() <= 1) continue;
            break;
        }
        return componentDependencyModes.size() == 1 ? (DependencyMode)((Object)Iterables.getOnlyElement(componentDependencyModes)) : DependencyMode.BOTH;
    }

    public static boolean isDirect(Evidence evidence) {
        DependencyMode dependencyMode = Commons.determineDependencyMode(evidence);
        return dependencyMode == DependencyMode.BOTH || dependencyMode == DependencyMode.DIRECT;
    }

    public static enum DependencyMode {
        DIRECT,
        TRANSITIVE,
        BOTH;

    }

    public static enum VulnLevels {
        NEVER(0),
        LOW(-1),
        MEDIUM(-2),
        HIGH(-3),
        CRITICAL(-4),
        METHODS(-5);

        private final int exitValue;

        private VulnLevels(int exitValue) {
            this.exitValue = exitValue;
        }

        public int getExitValue() {
            return this.exitValue;
        }
    }

    public static enum Severity {
        Low,
        Medium,
        High,
        Critical;

    }
}

