/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.util.system;

import com.sourceclear.util.system.SystemItem;

public class SystemInfoResult {
    private final SystemItem item;
    private final String value;
    private final String valueTitle;
    private final String version;

    public SystemInfoResult(Builder builder) {
        this.item = builder.item;
        this.value = builder.value;
        this.valueTitle = builder.valueTitle;
        this.version = builder.version;
    }

    public SystemItem getItem() {
        return this.item;
    }

    public String getValue() {
        return this.value;
    }

    public String getValueTitle() {
        return this.valueTitle;
    }

    public String getVersion() {
        return this.version;
    }

    public static class Builder {
        private SystemItem item;
        private String value;
        private String valueTitle;
        private String version;

        public Builder withItem(SystemItem item) {
            this.item = item;
            return this;
        }

        public Builder withValue(String value) {
            this.value = value;
            return this;
        }

        public Builder withValueTitle(String valueTitle) {
            this.valueTitle = valueTitle;
            return this;
        }

        public Builder withVersion(String version) {
            this.version = version;
            return this;
        }

        public SystemInfoResult build() {
            return new SystemInfoResult(this);
        }
    }
}

