/*
 * Decompiled with CFR 0.152.
 */
package com.srcclr.sdk.build;

import com.srcclr.sdk.CoordinateType;
import com.srcclr.sdk.Coords;
import com.srcclr.sdk.LibraryGraph;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.shared.dependency.graph.DependencyNode;

@Immutable
public class MavenComponentGraphBuilder {
    public LibraryGraph buildGraph(DependencyNode node, String relativePathToPom) throws MojoExecutionException {
        if (node == null) {
            throw new MojoExecutionException("Maven unexpectedly found a null dependency graph node");
        }
        LibraryGraph.Builder depGraphBuilder = new LibraryGraph.Builder();
        Artifact nodeArtifact = node.getArtifact();
        Coords coords = new Coords.Builder().withCoordinateType(CoordinateType.MAVEN).withCoordinates(nodeArtifact.getGroupId(), nodeArtifact.getArtifactId()).withVersion(nodeArtifact.getVersion()).withScope(nodeArtifact.getScope()).build();
        depGraphBuilder.withCoords(coords);
        depGraphBuilder.withFilename(relativePathToPom);
        List children = node.getChildren();
        if (children != null) {
            for (DependencyNode child : children) {
                depGraphBuilder.withDirect(this.buildGraph(child, relativePathToPom));
            }
        }
        return depGraphBuilder.build();
    }
}

