/*
 * Decompiled with CFR 0.152.
 */
package com.srcclr.sdk;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.srcclr.sdk.Coords;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.validation.Valid;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class)
@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public class LibraryGraph {
    @Valid
    private Coords coords;
    @Valid
    private Set<LibraryGraph> directs;
    private String filename;
    private Integer lineNumber;
    private String moduleName;
    private String sha1;
    private String sha2;
    private String bytecodeHash;
    @JsonIgnore
    private int hashCache;
    @JsonIgnore
    private boolean isHashSet = false;

    public LibraryGraph() {
    }

    private LibraryGraph(Builder builder) {
        this.coords = builder.coords;
        this.directs = Collections.unmodifiableSet(builder.directs);
        this.filename = builder.filename;
        this.lineNumber = builder.lineNumber;
        this.moduleName = builder.moduleName;
        this.sha1 = builder.sha1;
        this.sha2 = builder.sha2;
        this.bytecodeHash = builder.bytecodeHash;
    }

    public int size() {
        int size = 1;
        for (LibraryGraph n : this.directs) {
            size += n.size();
        }
        return size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LibraryGraph that = (LibraryGraph)o;
        return Objects.equals(this.coords, that.coords) && Objects.equals(this.directs, that.directs) && Objects.equals(this.filename, that.filename) && Objects.equals(this.lineNumber, that.lineNumber);
    }

    public int hashCode() {
        if (!this.isHashSet) {
            this.hashCache = Objects.hash(this.coords, this.directs, this.filename, this.lineNumber);
            this.isHashSet = true;
        }
        return this.hashCache;
    }

    public Coords getCoords() {
        return this.coords;
    }

    public Set<LibraryGraph> getDirects() {
        return this.directs;
    }

    @Nullable
    public String getFilename() {
        return this.filename;
    }

    @Nullable
    public Integer getLineNumber() {
        return this.lineNumber;
    }

    @Nullable
    public String getModuleName() {
        return this.moduleName;
    }

    @Nullable
    public String getSha1() {
        return this.sha1;
    }

    @Nullable
    public String getSha2() {
        return this.sha2;
    }

    @Nullable
    public String getBytecodeHash() {
        return this.bytecodeHash;
    }

    public static class Builder {
        private String moduleName;
        private Coords coords;
        private Set<LibraryGraph> directs = new LinkedHashSet<LibraryGraph>();
        private String filename;
        private Integer lineNumber;
        private String sha1;
        private String sha2;
        private String bytecodeHash;

        public Builder withCoords(Coords coords) {
            this.coords = coords;
            return this;
        }

        public Builder withDirect(LibraryGraph direct) {
            this.directs.add(direct);
            return this;
        }

        public Builder withDirects(Set<LibraryGraph> directs) {
            this.directs = new HashSet<LibraryGraph>(directs);
            return this;
        }

        public Builder withFilename(String filename) {
            this.filename = filename;
            return this;
        }

        public Builder withLineNumber(Integer lineNumber) {
            this.lineNumber = lineNumber;
            return this;
        }

        public Builder withModuleName(String moduleName) {
            this.moduleName = moduleName;
            return this;
        }

        public Builder withSha1(String sha1) {
            this.sha1 = sha1;
            return this;
        }

        public Builder withSha2(String sha2) {
            this.sha2 = sha2;
            return this;
        }

        public Builder withBytecodeHash(String bytecodeHash) {
            this.bytecodeHash = bytecodeHash;
            return this;
        }

        public int hashCode() {
            return Objects.hash(this.coords, this.filename, this.lineNumber);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return Objects.equals(this.hashCode(), o.hashCode());
        }

        public LibraryGraph build() {
            return new LibraryGraph(this);
        }
    }
}

