/*
 * Decompiled with CFR 0.152.
 */
package com.srcclr.sdk;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.srcclr.sdk.Record;
import com.srcclr.sdk.ReportMetadata;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@JsonDeserialize(builder=Builder.class)
@Immutable
public class Report {
    private final ReportMetadata metadata;
    private final List<Record> records;

    private Report(Builder builder) {
        this.metadata = builder.metadata;
        this.records = Collections.unmodifiableList(builder.records);
    }

    @Nonnull
    public ReportMetadata getMetadata() {
        return this.metadata;
    }

    @Nonnull
    public List<Record> getRecords() {
        return this.records;
    }

    public static class Builder {
        private ReportMetadata metadata = new ReportMetadata.Builder().build();
        private List<Record> records = new LinkedList<Record>();

        public Builder withMetadata(ReportMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder withRecords(List<Record> records) {
            this.records = new ArrayList<Record>(records);
            return this;
        }

        public Report build() {
            return new Report(this);
        }
    }
}

