/*
 * Copyright (c) 2016 -  SourceClear Inc
 */

package com.srcclr.sdk;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/**
 * Utility class designed to reduce code duplication amongst the Builders used
 * throughout the package.
 * @param <B> the class extending this class
 * @param <T> the class built by the Builder implementation
 */
@SuppressWarnings("WeakerAccess")
abstract class BaseBuilder<B extends BaseBuilder, T extends BaseModel> {

  ///////////////////////////// Class Attributes \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  ////////////////////////////// Class Methods \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  //////////////////////////////// Attributes \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  List<Link> links = new LinkedList<>();

  /////////////////////////////// Constructors \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  ////////////////////////////////// Methods \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  @SuppressWarnings("unused")
  public B with_links(Map<String, String> linkRels) {
    for (final String rel : linkRels.keySet()) {
      links.add(new Link(rel, linkRels.get(rel)));
    }
    return withLinks(links);
  }

  public B withLinks(List<Link> links) {
    if (links == null) {
      this.links = new LinkedList<>();
    } else {
      this.links = links;
    }

    return instance();
  }

  //------------------------ Implements:

  //------------------------ Overrides:

  //---------------------------- Abstract Methods -----------------------------

  public abstract T build();

  //---------------------------- Utility Methods ------------------------------

  @SuppressWarnings("unchecked")
  private B instance() {
    return (B) this;
  }

  //---------------------------- Property Methods -----------------------------

}
