/*
 * © Copyright 2015 -  SourceClear Inc
 */

package com.srcclr.sdk;

import java.io.Serializable;

/**
 * Specifies the various build systems.
 */
public enum BuildType implements Serializable {

  ///////////////////////////// Class Attributes \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  UNKNOWN("Unknown"),
  MAVEN("Maven"),
  GRADLE("Gradle"),
  ANT("Ant"),
  GEM("GEM"),
  NPM("NPM"),
  PIP("PIP"),
  BOWER("BOWER"),
  GO("GO"),
  PACKAGIST("PACKAGIST"),
  SO("SO"),
  NUGET("NUGET"),
  RPM("RPM"),
  ALPINE("ALPINE"),
  DEBIAN("DEBIAN"),
  DOTNETCORE("DOTNETCORE"),
  MANUAL("MANUAL"),
  ;

  private static final long serialVersionUID = 1;

  ////////////////////////////// Class Methods \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  //////////////////////////////// Attributes \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  private final String name;

  /////////////////////////////// Constructors \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  BuildType(String name) {
    this.name = name;
  }

  ////////////////////////////////// Methods \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  //------------------------ Implements:

  //------------------------ Overrides:

  //---------------------------- Abstract Methods -----------------------------

  //---------------------------- Utility Methods ------------------------------

  //---------------------------- Property Methods -----------------------------

  public String getName() {
    return this.name;
  }

}
