/*
 * © Copyright 2017 -  SourceClear Inc
 */
package com.srcclr.sdk;

/**
 *
 */
public class CaseInsensitiveCoordNormalizer implements CoordNormalizer {

  ///////////////////////////// Class Attributes \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  private static final CaseInsensitiveCoordNormalizer singleton = new CaseInsensitiveCoordNormalizer();

  ////////////////////////////// Class Methods \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  public static CaseInsensitiveCoordNormalizer getSingleton() {
    return singleton;
  }

  //////////////////////////////// Attributes \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  /////////////////////////////// Constructors \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  CaseInsensitiveCoordNormalizer() {}

  ////////////////////////////////// Methods \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  //------------------------ Implements:

  @Override
  public String normalize(String coord) {
    if(coord == null) {
      return null;
    }
    coord = coord.toLowerCase();
    return coord.trim();
  }

  //------------------------ Overrides:

  //---------------------------- Abstract Methods -----------------------------

  //---------------------------- Utility Methods ------------------------------

  //---------------------------- Property Methods -----------------------------

}
