/*
 * © Copyright 2014 -  SourceClear Inc
 */
package com.srcclr.sdk;

import com.fasterxml.jackson.annotation.JsonCreator;

/**
 *
 */
public enum CoordinateType {

  MAVEN("Maven",2, "", IdentityNormalizer.getSingleton(), LanguageType.JAVA),
  GEM("GEM", 1, "ruby", IdentityNormalizer.getSingleton(), LanguageType.RUBY),
  NPM("NPM", 1, "", IdentityNormalizer.getSingleton(), LanguageType.JS),
  BOWER("BOWER", 1, "", IdentityNormalizer.getSingleton(), LanguageType.JS),
  COCOAPODS("COCOAPODS", 1, "", IdentityNormalizer.getSingleton(), LanguageType.OBJECTIVEC),
  PYPI("PYPI", 1, "source", PythonCoordNormalizer.getSingleton(), LanguageType.PYTHON),
  GO("GO", 1, "", CaseInsensitiveCoordNormalizer.getSingleton(), LanguageType.GO),
  PACKAGIST("PACKAGIST", 1, "", CaseInsensitiveCoordNormalizer.getSingleton(), LanguageType.PHP),
  SO("SO", 1, "", IdentityNormalizer.getSingleton(), LanguageType.CPP),
  NUGET("NUGET", 1, "", CaseInsensitiveCoordNormalizer.getSingleton(), LanguageType.CSHARP),
  RPM("RPM", 1, "", CaseInsensitiveCoordNormalizer.getSingleton(), LanguageType.OS),
  ALPINE("ALPINE", 2, "", IdentityNormalizer.getSingleton(), LanguageType.OS),
  DOTNETCORE("DOTNETCORE", 1, "", IdentityNormalizer.getSingleton(), LanguageType.CSHARP),
  DEBIAN("DEBIAN", 2, "", CaseInsensitiveCoordNormalizer.getSingleton(), LanguageType.OS),

  // "MANUAL" is used to identify libraries imported from Veracode's database, as part of the data delta project,
  // that are not found on any open-source registries. These are libraries that Veracode inserted manually.
  // According to Veracode, they only insert Java libraries manually; hence the coordinateCount is set to 2 and
  // LanguageType is set to Java.
  //
  // We don't expect to match these libraries by coordinates; hence on the engines side,
  // we don't expect any evidence of CoordinateType.MANUAL to be collected.
  // Rather, these libraries should be matched by hashes (sha1) as imported from VC's data.
  MANUAL("MANUAL", 2, "", IdentityNormalizer.getSingleton(), LanguageType.JAVA),
  ;

  ///////////////////////////// Class Attributes \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  ////////////////////////////// Class Methods \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  //////////////////////////////// Attributes \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  private final String name;

  private final int coordinateCount;

  private final String defaultPlatformName;

  private CoordNormalizer normalizer;

  private final LanguageType primaryLanguage;

  /////////////////////////////// Constructors \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  CoordinateType(String name, int coordinateCount, String defaultPlatformName, CoordNormalizer normalizer, LanguageType primaryLanguage) {
    this.name = name;
    this.coordinateCount = coordinateCount;
    this.defaultPlatformName = defaultPlatformName;
    this.normalizer = normalizer;
    this.primaryLanguage = primaryLanguage;
  }

  ////////////////////////////////// Methods \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  //------------------------ Implements:

  //------------------------ Overrides:

  //---------------------------- Abstract Methods -----------------------------

  //---------------------------- Utility Methods ------------------------------

  //---------------------------- Property Methods -----------------------------

  public int getCoordinateCount() {
    return coordinateCount;
  }

  public String getName() {
    return name;
  }

  public String getDefaultPlatformName() {
    return defaultPlatformName;
  }

  public LanguageType getPrimaryLanguage() {
    return primaryLanguage;
  }

  public CoordNormalizer getNormalizer() {
    return normalizer;
  }

  @JsonCreator
  public static CoordinateType toCoordType(String strVal) {
    if(strVal == null) {
      return null;
    }
    String upperVal = strVal.toUpperCase();
    return CoordinateType.valueOf(upperVal);
  }
}
