/*
 * Copyright (c) 2016 -  SourceClear Inc
 */

package com.srcclr.sdk;

import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.SafeConstructor;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

/**
 * Parser class for srcclr.yml
 */
public final class Directives {

  ///////////////////////////// Class Attributes \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  ////////////////////////////// Class Methods \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  /**
   * Parses the directives located in the supplied YAML file.
   * @return An initialized Map populated with directives from the supplied File.
   * @throws IOException for any I/O related issues
   * @throws RuntimeException for any file content related issues
   */
  public static Map<String, Object> parseDirectives(InputStream is) throws IOException {

    try {
      final Object yamlObj = new Yaml(new SafeConstructor(new LoaderOptions())).load(is);

      //
      // It appears (I can't find it documented anywhere) that yamlObj is null if the
      // InputStream was empty.
      //
      if (yamlObj == null) {
        return new HashMap<>();
      }


      Map<String, Object> directives = (Map<String, Object>) yamlObj;


      //
      // Our Yaml library will also allow for null keys, which
      // will confuse downstream consumers.  Let's filter those out now.
      //
      // This would be much simpler with Java 8
      //
      Collection<String> nullValues = new HashSet<>();

      for (Map.Entry<String, Object> entry : directives.entrySet()) {
        if (entry.getValue() == null) {
          nullValues.add(entry.getKey());
        }
      }

      for (String key : nullValues) {
        directives.remove(key);
      }

      return directives;

    } catch (ClassCastException e) {
      throw new RuntimeException("Unexpected structure in the provided YaML", e);
    } finally {
      is.close();
    }
  }

  //////////////////////////////// Attributes \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  /////////////////////////////// Constructors \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  private Directives() {}

  ////////////////////////////////// Methods \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  //------------------------ Implements:

  //------------------------ Overrides:

  //---------------------------- Abstract Methods -----------------------------

  //---------------------------- Utility Methods ------------------------------

  //---------------------------- Property Methods -----------------------------

}
