/*
 * Copyright (c) 2016 -  SourceClear Inc
 */

package com.srcclr.sdk;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;

/**
 *
 */
@Immutable
@JsonDeserialize(builder=Library.Builder.class)
public class Library extends BaseModel {

  public static class Builder extends BaseBuilder<Builder, Library> {

    private String name;

    private String description;

    private String author;

    private String authorUrl;

    private LanguageType language;

    private CoordinateType coordinateType;

    private String coordinate1;

    private String coordinate2;

    private String bugTrackerUrl;

    private String codeRepoType;

    private String codeRepoUrl;

    private String latestRelease;

    private Date latestReleaseDate;

    private String recommendedVersion;

    private Collection<LibraryVersion> versions = new LinkedList<>();

    public Builder withName(String name) {
      this.name = name;
      return this;
    }

    public Builder withDescription(String description) {
      this.description = description;
      return this;
    }

    public Builder withAuthor(String author) {
      this.author = author;
      return this;
    }

    public Builder withAuthorUrl(String authorUrl) {
      this.authorUrl = authorUrl;
      return this;
    }

    public Builder withLanguage(LanguageType language) {
      this.language = language;
      return this;
    }

    public Builder withCoordinateType(CoordinateType coordinateType) {
      this.coordinateType = coordinateType;
      return this;
    }

    public Builder withCoordinate1(String coordinate1) {
      this.coordinate1 = coordinate1;
      return this;
    }

    public Builder withCoordinate2(String coordinate2) {
      this.coordinate2 = coordinate2;
      return this;
    }

    public Builder withBugTrackerUrl(String bugTrackerUrl) {
      this.bugTrackerUrl = bugTrackerUrl;
      return this;
    }

    public Builder withCodeRepoType(String codeRepoType) {
      this.codeRepoType = codeRepoType;
      return this;
    }

    public Builder withCodeRepoUrl(String codeRepoUrl) {
      this.codeRepoUrl = codeRepoUrl;
      return this;
    }

    public Builder withLatestRelease(String latestRelease) {
      this.latestRelease = latestRelease;
      return this;
    }

    public Builder withLatestReleaseDate(Date latestReleaseDate) {
      this.latestReleaseDate = latestReleaseDate;
      return this;
    }

    public Builder withRecommendedVersion(String recommendedVersion) {
      this.recommendedVersion = recommendedVersion;
      return this;
    }

    public Builder withVersions(Collection<LibraryVersion> versions) {
      this.versions = versions;
      return this;
    }

    public Library build() {
      return new Library(this);
    }
  }

  ///////////////////////////// Class Attributes \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  ////////////////////////////// Class Methods \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  /////////////////////mvn clea/////////// Attributes \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  private final  String name;

  private final  String description;

  private final  String author;

  private final  String authorUrl;

  private final  LanguageType language;

  private final  CoordinateType coordinateType;

  private final  String coordinate1;

  private final  String coordinate2;

  private final  String bugTrackerUrl;

  private final  String codeRepoType;

  private final  String codeRepoUrl;

  private final  String latestRelease;

  private final  Date latestReleaseDate;

  private final String recommendedVersion;

  private final  Collection<LibraryVersion> versions;

  /////////////////////////////// Constructors \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\  

  private Library(Builder builder) {
    super(builder);
    name = builder.name;
    description = builder.description;
    author = builder.author;
    authorUrl = builder.authorUrl;
    language = builder.language;
    coordinateType = builder.coordinateType;
    coordinate1 = builder.coordinate1;
    coordinate2 = builder.coordinate2;
    bugTrackerUrl = builder.bugTrackerUrl;
    codeRepoType = builder.codeRepoType;
    codeRepoUrl = builder.codeRepoUrl;
    latestRelease = builder.latestRelease;
    latestReleaseDate = builder.latestReleaseDate;
    recommendedVersion = builder.recommendedVersion;
    versions = Collections.unmodifiableCollection(builder.versions);
  }

  ////////////////////////////////// Methods \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  //------------------------ Implements:

  //------------------------ Overrides:

  //---------------------------- Abstract Methods -----------------------------

  //---------------------------- Utility Methods ------------------------------

  //---------------------------- Property Methods -----------------------------

  @Nonnull
  public String getName() {
    return name;
  }

  public String getDescription() {
    return description;
  }

  public String getAuthor() {
    return author;
  }

  public String getAuthorUrl() {
    return authorUrl;
  }

  @Nonnull
  public LanguageType getLanguage() {
    return language;
  }

  public CoordinateType getCoordinateType() {
    return coordinateType;
  }

  public String getCoordinate1() {
    return coordinate1;
  }

  public String getCoordinate2() {
    return coordinate2;
  }

  public String getBugTrackerUrl() {
    return bugTrackerUrl;
  }

  public String getCodeRepoType() {
    return codeRepoType;
  }

  public String getCodeRepoUrl() {
    return codeRepoUrl;
  }

  public String getLatestRelease() {
    return latestRelease;
  }

  public Date getLatestReleaseDate() {
    return latestReleaseDate;
  }

  @Nonnull
  public Collection<LibraryVersion> getVersions() {
    return versions;
  }

  @Nullable
  public String getRecommendedVersion() {
    return recommendedVersion;
  }
}
