package com.srcclr.sdk;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Arrays;

public class LibraryGraphContainerDeserializer extends JsonDeserializer<LibraryGraphContainer> {

  @Override
  public LibraryGraphContainer deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
    ObjectCodec codec = jsonParser.getCodec();
    JsonNode node = codec.readTree(jsonParser);
    JsonNode generationNode = node.get("generation");
    Long generation = (generationNode == null) ? null : generationNode.asLong();
    try {
      LibraryGraphSerializer.checkGeneration(generation);
    } catch (LibraryGraphSerializationException e) {
      throw new IOException(e);
    }
    JsonNode graphsNode = node.get("graphs");
    if(graphsNode == null) {
      throw new IOException("Expected a component graph list in the graphs field!");
    }
    LibraryGraph[] graphs = codec.treeToValue(graphsNode, LibraryGraph[].class);
    return new LibraryGraphContainer.Builder().withGraphs(Arrays.asList(graphs)).build();
  }
}
