/*
 * © Copyright 2015 -  SourceClear Inc
 */

package com.srcclr.sdk;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * Simple utility class designed to read/write JSON and ComponentGraphContainers.
 */
public final class LibraryGraphSerializer {

  ///////////////////////////// Class Attributes \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  private static long CURRENT_GENERATION = 1;

  private static final ObjectMapper MAPPER = new ObjectMapper()
    .configure(JsonGenerator.Feature.IGNORE_UNKNOWN, true)
    .enable(SerializationFeature.INDENT_OUTPUT);

  ////////////////////////////// Class Methods \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  public static void checkGeneration(Long generation) throws LibraryGraphSerializationException {
    if(generation == null) {
      if(CURRENT_GENERATION != 1) {
        throw new LibraryGraphSerializationException("Generation number missing from component graph JSON");
      } else {
        return;
      }
    }
    if(generation != CURRENT_GENERATION) {
       throw new LibraryGraphSerializationException("Cannot deserialize JSON: Expected to deserialize generation " + LibraryGraphSerializer.getCurrentGeneration() + " but found " + generation);
    }
  }

  public static long getCurrentGeneration() {
    return CURRENT_GENERATION;
  }

  /**
   * Serialize a LibraryGraphContainer to JSON into the supplied OutputStream.
   */
  public static void write(LibraryGraphContainer container, OutputStream os) throws IOException {
    MAPPER.writeValue(os, container);
  }

  /**
   * Deserialize a LibraryGraphContainer from the suppplied InputStream.
   */
  public static LibraryGraphContainer read(InputStream is) throws IOException {
    return MAPPER.readValue(is, LibraryGraphContainer.class);
  }

  //////////////////////////////// Attributes \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  /////////////////////////////// Constructors \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  private LibraryGraphSerializer() {}

  ////////////////////////////////// Methods \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  //------------------------ Implements:

  //------------------------ Overrides:

  //---------------------------- Abstract Methods -----------------------------

  //---------------------------- Utility Methods ------------------------------

  //---------------------------- Property Methods -----------------------------

}
