/*
 * Copyright (c) 2016 -  SourceClear Inc
 */

package com.srcclr.sdk;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

/**
 *
 */
@Immutable
@JsonDeserialize(builder=LibraryLicense.Builder.class)
public class LibraryLicense {

  public static class Builder {

    private String name;

    private String license;

    private Boolean fromParentPom;

    private String risk;

    private String spdxId;

    public Builder withName(String name) {
      this.name = name;
      return this;
    }

    public Builder withLicense(String license) {
      this.license = license;
      return this;
    }

    public Builder withFromParentPom(Boolean fromParentPom) {
      this.fromParentPom = fromParentPom;
      return this;
    }

    public Builder withRisk(String risk) {
      this.risk = risk;
      return this;
    }

    public Builder withSpdxId(String spdxId) {
      this.spdxId = spdxId;
      return this;
    }

    public LibraryLicense build() {
      return new LibraryLicense(this);
    }
  }

  ///////////////////////////// Class Attributes \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  ////////////////////////////// Class Methods \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  //////////////////////////////// Attributes \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  private final String name;

  private final String license;

  private final Boolean fromParentPom;

  private final String risk;

  private final String spdxId;

  /////////////////////////////// Constructors \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\  

  private LibraryLicense(Builder builder) {
    name = builder.name;
    license = builder.license;
    fromParentPom = builder.fromParentPom;
    risk = builder.risk;
    spdxId = builder.spdxId;
  }

  ////////////////////////////////// Methods \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  //------------------------ Implements:

  //------------------------ Overrides:

  //---------------------------- Abstract Methods -----------------------------

  //---------------------------- Utility Methods ------------------------------

  //---------------------------- Property Methods -----------------------------


  public String getName() {
    return name;
  }

  public String getLicense() {
    return license;
  }

  @Nullable
  public Boolean getFromParentPom() {
    return fromParentPom;
  }

  @Nullable
  public String getRisk() {
    return risk;
  }

  @Nullable
  public String getSpdxId() {
    return spdxId;
  }

}
