/*
 * Copyright (c) 2016 -  SourceClear Inc
 */

package com.srcclr.sdk;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

import javax.annotation.concurrent.Immutable;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

/**
 *
 */
@Immutable
@JsonDeserialize(builder=LibraryVersion.Builder.class)
public class LibraryVersion extends BaseModel {

  public static class Builder extends BaseBuilder<Builder, LibraryVersion>{

    private String version;

    private Date releaseDate;

    private String sha1;

    private String sha2;

    private String bytecodeHash;

    private String platform;

    private List<LibraryLicense> licenses = new LinkedList<>();

    public Builder withVersion(String version) {
      this.version = version;
      return this;
    }

    public Builder withReleaseDate(Date releaseDate) {
      this.releaseDate = releaseDate;
      return this;
    }

    public Builder withSha1(String sha1) {
      this.sha1 = sha1;
      return this;
    }

    public Builder withSha2(String sha2) {
      this.sha2 = sha2;
      return this;
    }

    public Builder withBytecodeHash(String bytecodeHash) {
      this.bytecodeHash = bytecodeHash;
      return this;
    }

    public Builder withPlatform(String platform) {
      this.platform = platform;
      return this;
    }

    public Builder withLicenses(List<LibraryLicense> licenses) {
      this.licenses  = licenses;
      return this;
    }

    public LibraryVersion build() {
      return new LibraryVersion(this);
    }
  }

  ///////////////////////////// Class Attributes \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  ////////////////////////////// Class Methods \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  //////////////////////////////// Attributes \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  private final String version;

  private final Date releaseDate;

  private final String sha1;

  private final String sha2;

  private final String bytecodeHash;

  private final String platform;

  private final List<LibraryLicense> licenses;

  /////////////////////////////// Constructors \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\  

  private LibraryVersion(Builder builder) {
    super(builder);
    version = builder.version;
    releaseDate = builder.releaseDate;
    sha1 = builder.sha1;
    sha2 = builder.sha2;
    bytecodeHash = builder.bytecodeHash;
    platform = builder.platform;
    licenses = builder.licenses;
  }

  ////////////////////////////////// Methods \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  //------------------------ Implements:

  //------------------------ Overrides:

  //---------------------------- Abstract Methods -----------------------------

  //---------------------------- Utility Methods ------------------------------

  //---------------------------- Property Methods -----------------------------

  public String getVersion() {
    return version;
  }

  public Date getReleaseDate() {
    return releaseDate;
  }

  public String getSha1() {
    return sha1;
  }

  public String getSha2() {
    return sha2;
  }

  public String getBytecodeHash() {
    return bytecodeHash;
  }

  public String getPlatform() {
    return platform;
  }

  public List<LibraryLicense> getLicenses() {
    return licenses;
  }
}
