package com.srcclr.sdk;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import java.io.Serializable;


// Copied wholesale from:
// https://github.com/spring-projects/spring-hateoas/blob/0.19.0.RELEASE
//     /src/main/java/org/springframework/hateoas/Link.java
@XmlType(name = "link", namespace = Link.ATOM_NAMESPACE)
@SuppressWarnings({"unused", "WeakerAccess"})
public class Link implements Serializable {
  private static final long serialVersionUID = 1782121L;

  public static final String ATOM_NAMESPACE = "http://www.w3.org/2005/Atom";

  public static final String REL_SELF = "self";
  public static final String REL_FIRST = "first";
  public static final String REL_PREVIOUS = "prev";
  public static final String REL_NEXT = "next";
  public static final String REL_LAST = "last";

  @XmlAttribute
  private String rel;
  @XmlAttribute
  private String href;
  /*
  @XmlTransient
  @JsonIgnore
  private UriTemplate template;
  */

  /**
   * Creates a new link to the given URI with the self rel.
   *
   * @see #REL_SELF
   * @param href must not be {@literal null} or empty.
   */
  public Link(String href) {
    this(href, REL_SELF);
  }

  public Link(String rel, String href) {
    this.rel = rel;
    this.href = href;
  }

  public Link() {
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj) {
      return true;
    }

    if (!(obj instanceof Link)) {
      return false;
    }

    Link that = (Link) obj;

    return this.href.equals(that.href) && this.rel.equals(that.rel);
  }

  @Override
  public int hashCode() {

    int result = 17;
    result += 31 * href.hashCode();
    result += 31 * rel.hashCode();
    return result;
  }

  @Override
  public String toString() {
    return String.format("<%s>;rel=\"%s\"", href, rel);
  }

  public String getRel() {
    return rel;
  }

  public String getHref() {
    return href;
  }
}
