/*
 * Copyright (c) 2016 -  SourceClear Inc
 */

package com.srcclr.sdk;

public class PythonCoordNormalizer implements CoordNormalizer {

  ///////////////////////////// Class Attributes \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  private static final PythonCoordNormalizer singleton = new PythonCoordNormalizer();

  ////////////////////////////// Class Methods \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  public static PythonCoordNormalizer getSingleton() {
    return singleton;
  }

  //////////////////////////////// Attributes \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  /////////////////////////////// Constructors \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  PythonCoordNormalizer() {}

  ////////////////////////////////// Methods \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  public String normalize(String coord) {
    if(coord == null) {
      return null;
    }
    // According to PEP-0426 Python package coordinates are case insensitive
    coord = coord.toLowerCase();
    // According to PEP-0426 Python indices must treat '-' and '_' as equivalent. This PEP does not
    // say anything about '.' being equivalent to other characters, but experiementation reveals that
    // it is treated as equivalent on PyPI.
    coord = coord.replace('-', '_');
    coord = coord.replace('.', '_');
    return coord;
  }

}
