/*
 * Copyright (c) 2016 -  SourceClear Inc
 */

package com.srcclr.sdk;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

import javax.annotation.concurrent.Immutable;
import java.util.Date;

/**
 * As the name implies, this contains metadata for a single report.  At the moment
 * the contents of this class are minimal, but more fields are expected to be added
 * in the future.
 */
@Immutable
@JsonDeserialize(builder=ReportMetadata.Builder.class)
public class ReportMetadata {

  public static class Builder {
    private Date requestDate = new Date();

    public Builder withRequestDate(Date requestDate) {
      this.requestDate = requestDate;
      return this;
    }

    public ReportMetadata build() {
      return new ReportMetadata(this);
    }
  }

  ///////////////////////////// Class Attributes \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  ////////////////////////////// Class Methods \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  //////////////////////////////// Attributes \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  private final Date requestDate;

  /////////////////////////////// Constructors \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\  

  private ReportMetadata(Builder builder) {
    this.requestDate = builder.requestDate;
  }

  ////////////////////////////////// Methods \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  //------------------------ Implements:

  //------------------------ Overrides:

  //---------------------------- Abstract Methods -----------------------------

  //---------------------------- Utility Methods ------------------------------

  //---------------------------- Property Methods -----------------------------

  public Date getRequestDate() {
    return requestDate;
  }

}
