/*
 * Copyright (c) 2016 -  SourceClear Inc
 */

package com.srcclr.sdk;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

import javax.annotation.concurrent.Immutable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;

/**
 *
 */
@Immutable
@JsonDeserialize(builder=VulnerabilityLibrary.Builder.class)
public class VulnerabilityLibrary extends BaseModel {

  public static class Builder extends BaseBuilder<Builder, VulnerabilityLibrary> {

    private Collection<VulnerabilityLibraryDetails> details = new LinkedList<>();

    public Builder withDetails(Collection<VulnerabilityLibraryDetails> details) {
      this.details = new ArrayList<>(details);
      return this;
    }

    public VulnerabilityLibrary build() {
      return new VulnerabilityLibrary(this);
    }
  }

  ///////////////////////////// Class Attributes \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  ////////////////////////////// Class Methods \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  //////////////////////////////// Attributes \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  private final Collection<VulnerabilityLibraryDetails> details;

  /////////////////////////////// Constructors \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\  

  private VulnerabilityLibrary(Builder builder) {
    super(builder);
    details = Collections.unmodifiableCollection(builder.details);
  }

  ////////////////////////////////// Methods \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  //------------------------ Implements:

  //------------------------ Overrides:

  //---------------------------- Abstract Methods -----------------------------

  //---------------------------- Utility Methods ------------------------------

  //---------------------------- Property Methods -----------------------------

  public Collection<VulnerabilityLibraryDetails> getDetails() {
    return details;
  }

}
