/*
 * Copyright (c) 2016 -  SourceClear Inc
 */

package com.srcclr.sdk;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

import javax.annotation.concurrent.Immutable;

/**
 *
 */
@Immutable
@JsonDeserialize(builder=VulnerabilityLibraryDetails.Builder.class)
public class VulnerabilityLibraryDetails {

  public static class Builder {

    private String updateToVersion;

    private String versionRange;

    private String fixText;

    private String patch;

    public Builder withUpdateToVersion(String updateToVersion) {
      this.updateToVersion = updateToVersion;
      return this;
    }

    public Builder withVersionRange(String versionRange) {
      this.versionRange = versionRange;
      return this;
    }

    public Builder withFixText(String fixText) {
      this.fixText = fixText;
      return this;
    }

    public Builder withPatch(String patch) {
      this.patch = patch;
      return this;
    }

    public VulnerabilityLibraryDetails build() {
      return new VulnerabilityLibraryDetails(this);
    }
  }

  ///////////////////////////// Class Attributes \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  ////////////////////////////// Class Methods \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  //////////////////////////////// Attributes \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  private final String updateToVersion;

  private final String versionRange;

  private final String fixText;

  private final String patch;

  /////////////////////////////// Constructors \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\  

  private VulnerabilityLibraryDetails(Builder builder) {
    updateToVersion = builder.updateToVersion;
    versionRange = builder.versionRange;
    fixText = builder.fixText;
    patch = builder.patch;
  }

  ////////////////////////////////// Methods \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

  //------------------------ Implements:

  //------------------------ Overrides:

  //---------------------------- Abstract Methods -----------------------------

  //---------------------------- Utility Methods ------------------------------

  //---------------------------- Property Methods -----------------------------


  public String getUpdateToVersion() {
    return updateToVersion;
  }

  public String getVersionRange() {
    return versionRange;
  }

  public String getFixText() {
    return fixText;
  }

  public String getPatch() {
    return patch;
  }
}
