/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.icongenerator;

import com.sshtools.icongenerator.AwesomeIcon;
import com.sshtools.icongenerator.Colors;
import com.sshtools.icongenerator.IconGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.ServiceLoader;

public class IconBuilder {
    public static final int RANDOM_TEXT_COLOR = -4;
    public static final int AUTO_TEXT_COLOR = -3;
    public static final int AUTO_TEXT_COLOR_WHITE = -1;
    public static final int AUTO_TEXT_COLOR_BLACK = -2;
    public static final int AUTO_COLOR = -3;
    public static final int RANDOM_COLOR = -4;
    private IconShape shape = IconShape.RECTANGLE;
    private String text = "";
    private float borderThickness = 0.0f;
    private float height = 64.0f;
    private float width = 64.0f;
    private String fontName = "sans-serif-light";
    private int textColor = -3;
    private int borderColor;
    private int fixedFontSize = -1;
    private boolean isBold = false;
    private TextCase textCase;
    private TextContent textContent;
    private float radius;
    private AwesomeIconMode awesomeIconMode = AwesomeIconMode.NONE;
    private int color = -3;
    private AwesomeIcon icon;
    private Map<Class<?>, IconGenerator<?>> generators = new HashMap();
    private int maxTextLength = -1;
    private Colors theme = null;
    private int backgroundOpacity = 255;

    public IconBuilder() {
        this.textCase = TextCase.ORIGINAL;
        this.textContent = TextContent.ORIGINAL;
        for (IconGenerator gen : ServiceLoader.load(IconGenerator.class)) {
            if (!gen.isValid()) continue;
            this.generators.put(gen.getIconClass(), gen);
        }
    }

    public <T> void generator(Class<T> clazz, IconGenerator<T> generate) {
        if (generate == null) {
            this.generators.remove(clazz);
        } else {
            this.generators.put(clazz, generate);
        }
    }

    public <T> T build(Class<T> iconClass, Object ... args) {
        IconGenerator<?> gen = this.generators.get(iconClass);
        if (gen == null) {
            throw new UnsupportedOperationException("Icon's of class " + iconClass + " are not supported.");
        }
        return (T)gen.generate(this, args);
    }

    public AwesomeIcon icon() {
        return this.icon;
    }

    public IconBuilder icon(AwesomeIcon icon) {
        this.icon = icon;
        this.awesomeIconMode = icon == null ? AwesomeIconMode.NONE : AwesomeIconMode.SPECIFIC;
        return this;
    }

    public float width() {
        return this.width;
    }

    public IconBuilder width(float width) {
        this.width = width;
        return this;
    }

    public IconBuilder height(float height) {
        this.height = height;
        return this;
    }

    public float height() {
        return this.height;
    }

    public IconBuilder maxTextLength(int maxTextLength) {
        this.maxTextLength = maxTextLength;
        return this;
    }

    public int maxTextLength() {
        return this.maxTextLength;
    }

    public IconBuilder textColor(int r, int g, int b) {
        return this.textColor(IconBuilder.encodeRGB(r, g, b));
    }

    public IconBuilder borderColor(int color) {
        this.borderColor = color;
        return this;
    }

    public IconBuilder borderColor(int r, int g, int b) {
        return this.borderColor(IconBuilder.encodeRGB(r, g, b));
    }

    public int borderColor() {
        return this.borderColor;
    }

    public IconBuilder textColor(int color) {
        this.textColor = color;
        return this;
    }

    public IconBuilder awesomeIconMode(AwesomeIconMode awesomeIconMode) {
        this.awesomeIconMode = awesomeIconMode;
        return this;
    }

    public AwesomeIconMode awesomeIconMode() {
        return this.awesomeIconMode;
    }

    public IconBuilder randomTextColor() {
        this.textColor = -4;
        return this;
    }

    public IconBuilder autoTextColor() {
        this.textColor = -3;
        return this;
    }

    public IconBuilder autoTextColorPreferWhite() {
        this.textColor = -1;
        return this;
    }

    public IconBuilder autoTextColorPreferBlack() {
        this.textColor = -2;
        return this;
    }

    public int textColor() {
        return this.textColor;
    }

    public IconBuilder border(float thickness) {
        this.borderThickness = thickness;
        return this;
    }

    public float border() {
        return this.borderThickness;
    }

    public IconBuilder fontName(String font) {
        this.fontName = font;
        return this;
    }

    public String fontName() {
        return this.fontName;
    }

    public IconBuilder fontSize(int size) {
        this.fixedFontSize = size;
        return this;
    }

    public int fontSize() {
        return this.fixedFontSize;
    }

    public IconBuilder bold(boolean bold) {
        this.isBold = bold;
        return this;
    }

    public boolean bold() {
        return this.isBold;
    }

    public float radius() {
        return this.radius;
    }

    public IconBuilder textCase(TextCase textCase) {
        this.textCase = textCase;
        return this;
    }

    public TextCase textCase() {
        return this.textCase;
    }

    public IconBuilder textContent(TextContent textContent) {
        this.textContent = textContent;
        return this;
    }

    public TextContent textContent() {
        return this.textContent;
    }

    public IconBuilder shape(IconShape shape) {
        this.shape = shape;
        return this;
    }

    public IconShape shape() {
        return this.shape;
    }

    public IconBuilder autoShape() {
        this.shape = IconShape.AUTOMATIC;
        return this;
    }

    public IconBuilder rect() {
        this.shape = IconShape.RECTANGLE;
        return this;
    }

    public IconBuilder round() {
        this.shape = IconShape.ROUND;
        return this;
    }

    public IconBuilder roundRect(int radius) {
        this.shape = IconShape.ROUNDED;
        this.radius = radius;
        return this;
    }

    public IconBuilder text(String text) {
        this.text = text;
        return this;
    }

    public String text() {
        return this.text;
    }

    public Colors theme() {
        return this.theme;
    }

    public IconBuilder theme(Colors theme) {
        this.theme = theme;
        return this;
    }

    public IconBuilder autoColor() {
        this.color = -3;
        return this;
    }

    public IconBuilder randomColor() {
        this.color = -4;
        return this;
    }

    public int backgroundOpacity() {
        return this.backgroundOpacity;
    }

    public IconBuilder backgroundOpacity(int backgroundOpacity) {
        this.backgroundOpacity = backgroundOpacity;
        return this;
    }

    public int color() {
        return this.color;
    }

    public IconBuilder color(int r, int g, int b) {
        return this.color(IconBuilder.encodeRGB(r, g, b));
    }

    public IconBuilder color(int color) {
        this.color = color;
        return this;
    }

    public String computedText() {
        if (this.text == null) {
            return "";
        }
        String v = this.textCase.textForCase(this.textContent.textForContent(this.text));
        return this.maxTextLength != -1 && v.length() > this.maxTextLength ? v.substring(0, this.maxTextLength) : v;
    }

    public IconShape computedShape() {
        return this.shape.shapeForText(this.text);
    }

    public int computedColor() {
        if (this.color == -3) {
            if (this.theme == null || this.text == null && this.icon == null) {
                return this.text == null && this.icon == null ? 0 : (this.text == null ? this.icon : this.text).hashCode() & 0xFFFFFF;
            }
            return this.theme.color(this.text == null ? this.icon : this.text);
        }
        if (this.color == -4) {
            if (this.theme == null) {
                return new Random().nextInt() & 0xFFFFFF;
            }
            return this.theme.randomColor();
        }
        return this.color;
    }

    public int computedBorderColor() {
        if (this.borderColor == -3) {
            return this.computedColor();
        }
        if (this.borderColor == -4) {
            if (this.theme == null) {
                return new Random().nextInt() & 0xFFFFFF;
            }
            return this.theme.randomColor();
        }
        return this.borderColor;
    }

    public int computedTextColor(int background) {
        if (this.textColor < 0) {
            if (this.textColor == -4) {
                return new Random().nextInt() & 0xFFFFFF;
            }
            int[] rgb = IconBuilder.decodeRGB(background);
            float[] hsb = IconBuilder.toHSB(rgb[0], rgb[1], rgb[2]);
            switch (this.textColor) {
                case -3: {
                    if (hsb[2] > 0.9f) {
                        return 0;
                    }
                    return 0xFFFFFF;
                }
                case -1: {
                    if (hsb[1] < 0.1f && hsb[2] > 0.1f) {
                        return 0;
                    }
                    return 0xFFFFFF;
                }
                case -2: {
                    if (hsb[1] > 0.9f || hsb[2] > 0.9f) {
                        return 0;
                    }
                    return 0xFFFFFF;
                }
            }
        }
        return this.textColor;
    }

    public AwesomeIcon computedIcon() {
        if (this.icon == null) {
            switch (this.awesomeIconMode) {
                case AUTO_MATCH: {
                    return AwesomeIcon.match(this.text);
                }
                case AUTO_TEXT: {
                    return AwesomeIcon.icon(this.text);
                }
            }
        }
        return this.icon;
    }

    public static float[] toHSB(int red, int green, int blue) {
        int cmin;
        int max;
        float h = 0.0f;
        float s = 0.0f;
        float b = 0.0f;
        int n = max = red > green ? red : green;
        if (blue > max) {
            max = blue;
        }
        int n2 = cmin = red < green ? red : green;
        if (blue < cmin) {
            cmin = blue;
        }
        b = (float)max / 255.0f;
        s = max != 0 ? (float)(max - cmin) / (float)max : 0.0f;
        if (s > 0.0f) {
            float redc = (float)(max - red) / (float)(max - cmin);
            float greenc = (float)(max - green) / (float)(max - cmin);
            float bluec = (float)(max - blue) / (float)(max - cmin);
            h = red == max ? bluec - greenc : (green == max ? 2.0f + redc - bluec : 4.0f + greenc - redc);
            if ((h /= 6.0f) < 0.0f) {
                h += 1.0f;
            }
        }
        return new float[]{h, s, b};
    }

    public static int encodeRGB(int r, int g, int b) {
        return (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static int[] decodeRGB(int v) {
        int r = v >> 16 & 0xFF;
        int g = v >> 8 & 0xFF;
        int b = v & 0xFF;
        return new int[]{r, g, b};
    }

    public static enum IconShape {
        RECTANGLE,
        ROUND,
        ROUNDED,
        AUTOMATIC;


        public IconShape shapeForText(String text) {
            if (text == null || this != AUTOMATIC) {
                return this == AUTOMATIC ? ROUND : this;
            }
            return IconShape.values()[Math.abs(text.hashCode()) % (IconShape.values().length - 1)];
        }
    }

    public static enum AwesomeIconMode {
        NONE,
        SPECIFIC,
        AUTO_MATCH,
        AUTO_TEXT;

    }

    public static enum TextCase {
        UPPER,
        LOWER,
        ORIGINAL;


        public final String textForCase(String text) {
            if (text == null) {
                return null;
            }
            switch (this) {
                case UPPER: {
                    return text.toUpperCase();
                }
                case LOWER: {
                    return text.toUpperCase();
                }
            }
            return text;
        }
    }

    public static enum TextContent {
        INITIALS,
        FIRST_WORD,
        LAST_WORD,
        ORIGINAL;


        public final String textForContent(String text) {
            if (text == null) {
                return null;
            }
            switch (this) {
                case INITIALS: {
                    String[] words = text.split("\\s+");
                    StringBuilder b = new StringBuilder();
                    for (String w : words) {
                        b.append(w.charAt(0));
                    }
                    return b.toString();
                }
                case FIRST_WORD: {
                    String[] words = text.split("\\s+");
                    return words[0];
                }
                case LAST_WORD: {
                    String[] words = text.split("\\s+");
                    return words[words.length - 1];
                }
            }
            return text;
        }
    }
}

